/*
 * Decompiled with CFR 0.152.
 */
package betterwithaddons.tileentity;

import betterwithaddons.block.EriottoMod.BlockNabe;
import betterwithaddons.crafting.manager.CraftingManagerNabe;
import betterwithaddons.crafting.recipes.INabeRecipe;
import betterwithaddons.tileentity.SimpleItemStackHandler;
import betterwithaddons.tileentity.TileEntityBase;
import betterwithaddons.util.InventoryUtil;
import betterwithaddons.util.NabeResult;
import betterwithaddons.util.StackResult;
import betterwithmods.common.registry.heat.BWMHeatRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileEntityNabe
extends TileEntityBase
implements ITickable {
    public ItemStackHandler inventory = this.createItemStackHandler();
    public int fireIntensity;
    private NabeResult result = new NabeResult(FluidRegistry.getFluidStack((String)"water", (int)0));
    private int boilingTime = 0;
    public Random random = new Random();

    public ItemStackHandler createItemStackHandler() {
        return new SimpleItemStackHandler(this, true, 6){

            public int getSlotLimit(int slot) {
                return 1;
            }
        };
    }

    @Override
    public void writeDataToNBT(NBTTagCompound compound) {
        compound.func_74782_a("inventory", (NBTBase)this.inventory.serializeNBT());
        compound.func_74782_a("fill", (NBTBase)this.result.serializeNBT());
        compound.func_74768_a("boilTime", this.boilingTime);
    }

    @Override
    public void readDataFromNBT(NBTTagCompound compound) {
        this.inventory = this.createItemStackHandler();
        this.inventory.deserializeNBT(compound.func_74775_l("inventory"));
        this.result = NabeResult.deserializeNBT(compound.func_74775_l("fill"));
        this.boilingTime = compound.func_74762_e("boilTime");
    }

    public int getFireIntensity() {
        return BWMHeatRegistry.getHeat((World)this.field_145850_b, (BlockPos)this.field_174879_c.func_177977_b());
    }

    public void func_73660_a() {
        if (this.field_145850_b == null || this.field_174879_c == null) {
            return;
        }
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        IBlockState upstate = this.field_145850_b.func_180495_p(this.field_174879_c.func_177984_a());
        if (!(state.func_177230_c() instanceof BlockNabe)) {
            return;
        }
        if (this.field_145850_b.field_72995_K && this.boilingTime > 0) {
            this.field_145850_b.func_175688_a(EnumParticleTypes.SMOKE_LARGE, (double)this.field_174879_c.func_177958_n() + this.random.nextDouble(), (double)this.field_174879_c.func_177956_o() + 1.0, (double)this.field_174879_c.func_177952_p() + this.random.nextDouble(), 0.0, 0.001, 0.0, new int[0]);
            return;
        }
        this.entityCollision();
        if (this.fireIntensity != this.getFireIntensity()) {
            this.validateFireIntensity();
        }
        if (!this.result.isFull() && this.isWater(upstate)) {
            this.resetWater();
        }
        if (this.hasWater() && this.fireIntensity > 0 && !this.isWater(upstate)) {
            List<ItemStack> compressedStacks = this.getCompressedStacks();
            INabeRecipe recipe = CraftingManagerNabe.getInstance().getMostValidRecipe(this, compressedStacks);
            if (recipe != null) {
                this.boilingTime += this.fireIntensity;
                if (this.boilingTime >= recipe.getBoilingTime(this)) {
                    this.result = recipe.craft(this, compressedStacks);
                    this.ejectMisfits();
                    this.boilingTime = 0;
                }
                this.func_70296_d();
                this.syncTE();
            } else {
                this.boilingTime = 0;
            }
        } else {
            this.boilingTime = Math.max(this.boilingTime - 1, 0);
        }
    }

    private boolean hasWater() {
        FluidStack fluidStack = this.result.getFluid();
        return this.result.isFull() && fluidStack != null && fluidStack.getFluid() == FluidRegistry.WATER;
    }

    private List<ItemStack> getCompressedStacks() {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            ItemStack stack = this.inventory.getStackInSlot(i).func_77946_l();
            if (stack.func_190926_b()) continue;
            stacks.stream().filter(existing -> existing.func_77969_a(stack)).forEach(existing -> {
                int count = Math.min(stack.func_190916_E(), existing.func_77976_d() - existing.func_190916_E());
                existing.func_190917_f(count);
                stack.func_190918_g(count);
            });
            if (stack.func_190926_b()) continue;
            stacks.add(stack);
        }
        return stacks;
    }

    private void resetWater() {
        this.result = new NabeResult(FluidRegistry.getFluidStack((String)"water", (int)1000));
        this.func_70296_d();
        this.syncTE();
    }

    private boolean isWater(IBlockState upstate) {
        return upstate.func_185904_a() == Material.field_151586_h;
    }

    private void validateFireIntensity() {
        this.fireIntensity = BWMHeatRegistry.getHeat((World)this.field_145850_b, (BlockPos)this.field_174879_c.func_177977_b());
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }

    public int countIngredients() {
        int count = 0;
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            if (this.inventory.getStackInSlot(i).func_190926_b()) continue;
            ++count;
        }
        return count;
    }

    public void onBlockActivated(EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack originalItem = playerIn.func_184586_b(hand);
        StackResult retrieved = this.result.take(originalItem.func_77946_l());
        if (!retrieved.isSuccess()) {
            if (!this.result.isFull()) {
                retrieved = this.putWater(originalItem);
            } else if (this.hasWater() && CraftingManagerNabe.getInstance().isValidItem(originalItem)) {
                retrieved = this.putItem(originalItem);
            }
        }
        if (retrieved.isSuccess()) {
            if (!retrieved.getReturnStack().func_190926_b()) {
                InventoryUtil.addItemToPlayer(playerIn, retrieved.getReturnStack());
            }
            EntityEquipmentSlot slot = hand == EnumHand.MAIN_HAND ? EntityEquipmentSlot.MAINHAND : EntityEquipmentSlot.OFFHAND;
            playerIn.func_184201_a(slot, retrieved.getOriginalStack());
        }
        this.func_70296_d();
        this.syncTE();
    }

    private void ejectMisfits() {
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            ItemStack stack = this.inventory.getStackInSlot(i);
            if (CraftingManagerNabe.getInstance().isValidItem(stack)) continue;
            this.inventory.setStackInSlot(i, ItemStack.field_190927_a);
            this.ejectStack(stack);
        }
    }

    private void ejectStack(ItemStack stack) {
        float xEject = this.random.nextFloat() * 0.5f - 0.25f;
        float zEject = this.random.nextFloat() * 0.5f - 0.25f;
        float xOff = 0.5f;
        float yOff = 1.2f;
        float zOff = 0.5f;
        EntityItem item = new EntityItem(this.func_145831_w(), (double)((float)this.field_174879_c.func_177958_n() + xOff), (double)((float)this.field_174879_c.func_177956_o() + yOff), (double)((float)this.field_174879_c.func_177952_p() + zOff), stack);
        item.field_70159_w = xEject * 0.1f;
        item.field_70181_x = 0.1f;
        item.field_70179_y = zEject * 0.1f;
        item.func_174869_p();
        this.func_145831_w().func_72838_d((Entity)item);
    }

    private boolean captureDroppedItems() {
        List<EntityItem> items = this.getCaptureItems(this.func_145831_w(), this.func_174877_v());
        SoundEvent sound = null;
        if (items.size() > 0) {
            for (EntityItem item : items) {
                if (CraftingManagerNabe.getInstance().isValidItem(item.func_92059_d()) && TileEntityNabe.putDropInInventoryAllSlots((IItemHandler)this.inventory, item)) {
                    sound = SoundEvents.field_187638_cR;
                }
                if (this.result.isFull() || !this.putDropWaterFill(item)) continue;
                sound = SoundEvents.field_187630_M;
            }
            if (sound != null) {
                this.func_145831_w().func_184148_a(null, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), sound, SoundCategory.PLAYERS, 0.2f, ((this.func_145831_w().field_73012_v.nextFloat() - this.func_145831_w().field_73012_v.nextFloat()) * 0.7f + 1.0f) * 2.0f);
                return true;
            }
        }
        return false;
    }

    private boolean putDropWaterFill(EntityItem item) {
        ItemStack stack = item.func_92059_d();
        StackResult result = this.putWater(stack.func_77946_l());
        item.func_92058_a(result.getOriginalStack());
        this.ejectStack(result.getReturnStack());
        return result.isSuccess();
    }

    public StackResult putItem(ItemStack stack) {
        ItemStack originalItem = stack.func_77946_l();
        ItemStack oneItem = originalItem.func_77979_a(1);
        ItemStack returnStack = TileEntityNabe.attemptToInsert((IItemHandler)this.inventory, oneItem);
        if (returnStack.func_190926_b()) {
            return new StackResult(true, originalItem, returnStack);
        }
        return new StackResult(false, stack);
    }

    private StackResult putWater(ItemStack stack) {
        FluidStack drainResource;
        FluidStack fluid;
        ItemStack original = stack.func_77946_l();
        ItemStack container = original.func_77979_a(1);
        IFluidHandlerItem handler = FluidUtil.getFluidHandler((ItemStack)container);
        if (handler != null && (fluid = handler.drain(drainResource = new FluidStack(FluidRegistry.WATER, 1000), false)) != null && fluid.getFluid() == FluidRegistry.WATER && fluid.amount >= 1000) {
            handler.drain(drainResource, true);
            this.resetWater();
            return new StackResult(true, original, handler.getContainer());
        }
        return new StackResult(false, stack);
    }

    private void entityCollision() {
        boolean flag = false;
        if (!this.isFull()) {
            flag = this.captureDroppedItems();
        }
        if (flag) {
            this.func_70296_d();
        }
    }

    private boolean isFull() {
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            ItemStack itemstack = this.inventory.getStackInSlot(i);
            if (!itemstack.func_190926_b() && itemstack.func_190916_E() == itemstack.func_77976_d()) continue;
            return false;
        }
        return true;
    }

    public static boolean putDropInInventoryAllSlots(IItemHandler inv, EntityItem entityItem) {
        boolean putAll = false;
        if (entityItem == null) {
            return false;
        }
        ItemStack itemstack = entityItem.func_92059_d().func_77946_l();
        ItemStack leftovers = TileEntityNabe.attemptToInsert(inv, itemstack);
        if (!leftovers.func_190926_b() && leftovers.func_190916_E() != 0) {
            entityItem.func_92058_a(leftovers);
        } else {
            putAll = true;
            entityItem.func_70106_y();
        }
        return putAll;
    }

    public static ItemStack attemptToInsert(IItemHandler inv, ItemStack stack) {
        ItemStack leftover = stack;
        for (int slot = 0; slot < inv.getSlots() && !(leftover = inv.insertItem(slot, leftover, false)).func_190926_b(); ++slot) {
        }
        return leftover;
    }

    public List<EntityItem> getCaptureItems(World worldIn, BlockPos pos) {
        return worldIn.func_175647_a(EntityItem.class, new AxisAlignedBB((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (double)pos.func_177958_n() + 1.0, (double)pos.func_177956_o() + 1.5, (double)pos.func_177952_p() + 1.0), EntitySelectors.field_94557_a);
    }

    public ItemStack consumeItem(ItemStack stack) {
        if (stack.func_77973_b().hasContainerItem(stack)) {
            return stack.func_77973_b().getContainerItem(stack);
        }
        stack.func_190918_g(1);
        return stack;
    }

    public NabeResult getFill() {
        return this.result;
    }
}

