/*
 * Decompiled with CFR 0.152.
 */
package betterwithaddons.tileentity;

import betterwithaddons.crafting.manager.CraftingManagerCherryBox;
import betterwithaddons.interaction.InteractionEriottoMod;
import betterwithaddons.tileentity.SimpleItemStackHandler;
import betterwithaddons.tileentity.TileEntityBase;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;

public class TileEntityCherryBox
extends TileEntityBase
implements ITickable {
    public int workTime;
    public int totalWorkTime;
    public SimpleItemStackHandler inventory = this.createItemStackHandler();

    public SimpleItemStackHandler createItemStackHandler() {
        return new SimpleItemStackHandler(this, true, 2);
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)((Object)this.inventory);
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public void writeDataToNBT(NBTTagCompound compound) {
        compound.func_179237_a(this.inventory.serializeNBT());
        compound.func_74768_a("WorkTime", this.workTime);
        compound.func_74768_a("WorkTimeTotal", this.totalWorkTime);
    }

    @Override
    public void readDataFromNBT(NBTTagCompound compound) {
        this.inventory = this.createItemStackHandler();
        this.inventory.deserializeNBT(compound);
        this.workTime = compound.func_74762_e("WorkTime");
        this.totalWorkTime = compound.func_74762_e("WorkTimeTotal");
    }

    public boolean isValidStructure() {
        return false;
    }

    public CraftingManagerCherryBox getManager() {
        return null;
    }

    public int getCookProgressScaled(int width) {
        return this.totalWorkTime != 0 && this.workTime != 0 ? this.workTime * width / this.totalWorkTime : 0;
    }

    public int getWorkTime(@Nullable ItemStack stack) {
        return InteractionEriottoMod.CHERRY_BOX_CRAFTING_TIME;
    }

    private boolean canWork() {
        ItemStack inputstack = this.inventory.getStackInSlot(0);
        ItemStack outputstack = this.inventory.getStackInSlot(1);
        if (inputstack.func_190926_b()) {
            return false;
        }
        ItemStack itemstack = this.getManager().getWorkResult(inputstack);
        if (itemstack.func_190926_b()) {
            return false;
        }
        if (outputstack.func_190926_b()) {
            return true;
        }
        if (!outputstack.func_77969_a(itemstack)) {
            return false;
        }
        int result = outputstack.func_190916_E() + itemstack.func_190916_E();
        return result <= this.getInventoryStackLimit() && result <= outputstack.func_77976_d();
    }

    public void finishItem() {
        ItemStack inputstack = this.inventory.getStackInSlot(0);
        ItemStack outputstack = this.inventory.getStackInSlot(1);
        if (this.canWork()) {
            ItemStack itemstack = this.getManager().getWorkResult(inputstack);
            if (outputstack.func_190926_b()) {
                this.inventory.setStackInSlot(1, itemstack.func_77946_l());
            } else if (outputstack.func_77973_b() == itemstack.func_77973_b()) {
                outputstack.func_190917_f(itemstack.func_190916_E());
            }
            inputstack.func_190918_g(1);
            if (inputstack.func_190916_E() <= 0) {
                this.inventory.setStackInSlot(0, ItemStack.field_190927_a);
            }
        }
    }

    public boolean isWorking() {
        return this.isValidStructure();
    }

    public int getWorkSpeed() {
        return 1;
    }

    private int getInventoryStackLimit() {
        return 64;
    }

    public void func_73660_a() {
        boolean flag1 = false;
        if (!this.field_145850_b.field_72995_K) {
            if (!this.isValidStructure()) {
                return;
            }
            ItemStack inputstack = this.inventory.getStackInSlot(0);
            if (this.isWorking() || !inputstack.func_190926_b()) {
                if (this.isWorking() && this.canWork()) {
                    this.workTime += this.getWorkSpeed();
                    this.totalWorkTime = this.getWorkTime(inputstack);
                    if (this.workTime >= this.totalWorkTime) {
                        this.workTime = 0;
                        this.totalWorkTime = this.getWorkTime(inputstack);
                        this.finishItem();
                        flag1 = true;
                    }
                } else {
                    this.workTime = 0;
                }
            } else if (!this.isWorking() && this.workTime > 0) {
                this.workTime = MathHelper.func_76125_a((int)(this.workTime - 2), (int)0, (int)this.totalWorkTime);
            }
        }
        if (flag1) {
            this.func_70296_d();
        }
    }
}

