/*
 * Decompiled with CFR 0.152.
 */
package betterwithaddons.interaction.jei.wrapper;

import betterwithaddons.block.EriottoMod.BlockNettedScreen;
import betterwithaddons.crafting.recipes.NetRecipe;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.BlankRecipeWrapper;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;

public class NetRecipeWrapper
extends BlankRecipeWrapper {
    public NetRecipe recipe;
    public BlockNettedScreen.SifterType type;

    public NetRecipeWrapper(NetRecipe recipe) {
        this.recipe = recipe;
        this.type = recipe.getType();
    }

    public void getIngredients(IIngredients ingredients) {
        ingredients.setInputs(ItemStack.class, this.getInputs());
        ingredients.setOutputs(ItemStack.class, this.getOutputs());
    }

    public List<ItemStack> getInputs() {
        List<ItemStack> inputs = this.getInputWithoutSand();
        int sandrequired = this.recipe.getSandRequired();
        if (sandrequired > 0) {
            inputs.add(new ItemStack((Block)Blocks.field_150354_m, sandrequired));
        }
        return inputs;
    }

    public List<ItemStack> getInputWithoutSand() {
        return this.recipe.getInput().stream().filter(stack -> !stack.func_190926_b()).map(ItemStack::func_77946_l).collect(Collectors.toList());
    }

    public List<ItemStack> getOutputs() {
        return this.recipe.getOutput().stream().filter(stack -> !stack.func_190926_b()).map(ItemStack::func_77946_l).collect(Collectors.toList());
    }

    @Nonnull
    public List<ItemStack> getSandInput() {
        ArrayList<ItemStack> outputs = new ArrayList<ItemStack>();
        int sandrequired = this.recipe.getSandRequired();
        if (sandrequired > 0) {
            outputs.add(new ItemStack((Block)Blocks.field_150354_m, sandrequired));
        }
        return outputs;
    }

    @Nonnull
    public List<ItemStack> getUpperOutputs() {
        ArrayList<ItemStack> outputs = new ArrayList<ItemStack>();
        int i = 0;
        for (ItemStack stack : this.recipe.getOutput()) {
            if (i++ % 2 != 0 || stack.func_190926_b()) continue;
            outputs.add(stack.func_77946_l());
        }
        return outputs;
    }

    @Nonnull
    public List<ItemStack> getLowerOutputs() {
        ArrayList<ItemStack> outputs = new ArrayList<ItemStack>();
        int i = 0;
        for (ItemStack stack : this.recipe.getOutput()) {
            if (i++ % 2 != 1 || stack == null) continue;
            outputs.add(stack.func_77946_l());
        }
        return outputs;
    }
}

