/*
 * Decompiled with CFR 0.152.
 */
package betterwithaddons.interaction;

import betterwithaddons.block.BlockBetterLilyPad;
import betterwithaddons.block.ModBlocks;
import betterwithaddons.crafting.recipes.QuartzCrystalRecipe;
import betterwithaddons.handler.AnimalCrossbreedHandler;
import betterwithaddons.handler.PatientiaHandler;
import betterwithaddons.handler.PlantCrossbreedHandler;
import betterwithaddons.handler.PortalHandler;
import betterwithaddons.handler.RedstoneBoilHandler;
import betterwithaddons.handler.RenewablesHandler;
import betterwithaddons.handler.SoulSandHandler;
import betterwithaddons.interaction.Interaction;
import betterwithaddons.interaction.ModInteractions;
import betterwithaddons.item.ItemBlockLilypad;
import betterwithaddons.item.ModItems;
import betterwithmods.common.BWMBlocks;
import betterwithmods.common.BWMItems;
import betterwithmods.common.BWRegistry;
import betterwithmods.common.blocks.BlockAesthetic;
import betterwithmods.common.blocks.BlockUrn;
import betterwithmods.common.items.ItemMaterial;
import betterwithmods.common.registry.bulk.recipes.BulkRecipe;
import betterwithmods.module.ModuleLoader;
import betterwithmods.module.hardcore.crafting.HCDiamond;
import betterwithmods.module.tweaks.CheaperAxes;
import betterwithmods.util.StackIngredient;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.OreIngredient;

public class InteractionBWR
extends Interaction {
    public static boolean ENABLED = false;
    public static boolean REDSTONE_SYNTHESIS = true;
    public static boolean REDSTONE_SYNTHESIS_EARLY = true;
    public static boolean HELLFIRE_EARLY = true;
    public static boolean BOILING_BUSHES = true;
    public static boolean WEAVING_WEBS = true;
    public static boolean LAPIS_FROM_WOOL = true;
    public static boolean DIAMOND_SYNTHESIS = true;
    public static boolean DIAMOND_RECOVERY = true;
    public static boolean GOLD_GRINDING = true;
    public static boolean NETHERRACK_SYNTHESIS = true;
    public static boolean QUARTZ_GROWING = true;
    public static boolean EMERALD_PORTAL = true;
    public static boolean LILYPADS_SPREAD = true;
    public static boolean MELT_HELLFIRE = true;
    public static boolean DUNG_TO_DIRT = true;
    public static boolean SAND_TO_CLAY = true;
    public static boolean CROSSBREED_PLANTS = true;
    public static boolean CROSSBREED_ANIMALS = true;
    public static boolean REDSTONE_BOILING = true;
    public static boolean SOULSAND_INFUSION = true;
    public static boolean BLAZE_GOLEMS = true;
    public static boolean BLAZE_BREEDING = true;
    public static int BLAZE_BREEDING_DELAY = 6000;
    public static int GOLD_PER_INGOT = 1;
    public static int REDSTONE_PER_SYNTHESIS = 7;
    public static double REDSTONE_BOILING_CHANCE = 0.1;
    public static int QUARTZ_GROWING_THRESHOLD = 20;
    public static int SOULSAND_INFUSION_THRESHOLD = 50;
    public static int DUNG_TO_DIRT_THRESHOLD = 300;
    public static int DUNG_TO_DIRT_AMBIENT_TEMP = 26;
    public static int MELT_HELLFIRE_THRESHOLD = 10;
    public static int BLAZE_BREEDING_RANGE = 3;

    @Override
    protected String getName() {
        return "addons.BetterWithRenewables";
    }

    @Override
    void setupConfig() {
        ENABLED = this.loadPropBool("Enabled", "Whether the Better With Renewables module is on. DISABLING THIS WILL DISABLE THE WHOLE MODULE.", ENABLED);
        REDSTONE_SYNTHESIS = this.loadPropBool("RedstoneSynthesis", "Allows redstone to be farbricated from concentrated hellfire and gold.", REDSTONE_SYNTHESIS);
        REDSTONE_SYNTHESIS_EARLY = this.loadPropBool("RedstoneSynthesisEarly", "Allows redstone to be synthesized earlier to create Hibachis.", REDSTONE_SYNTHESIS_EARLY);
        REDSTONE_PER_SYNTHESIS = this.loadPropInt("RedstonePerSynthesis", "How much redstone is obtained per bar of concentrated hellfire.", REDSTONE_PER_SYNTHESIS);
        HELLFIRE_EARLY = this.loadPropBool("HellfireEarly", "Allows hellfire dust to be created earlier in the tech tree.", HELLFIRE_EARLY);
        BOILING_BUSHES = this.loadPropBool("BoilingBushes", "Allows dead bushes to be created from oak saplings.", BOILING_BUSHES);
        WEAVING_WEBS = this.loadPropBool("WeavingWebs", "Allows webs to be created from string and slimeballs.", WEAVING_WEBS);
        LAPIS_FROM_WOOL = this.loadPropBool("LapisFromWool", "Allows lapis to be created from blue wool and clay.", LAPIS_FROM_WOOL);
        DIAMOND_SYNTHESIS = this.loadPropBool("DiamondSynthesis", "Allows diamonds to be fabricated from ghast tears.", DIAMOND_SYNTHESIS);
        DIAMOND_RECOVERY = this.loadPropBool("DiamondRecovery", "Allows diamond ingots to be taken apart into diamonds and iron ingots using strong alkaline.", DIAMOND_RECOVERY);
        GOLD_GRINDING = this.loadPropBool("GoldGrinding", "Allows only tools and armor made from gold to be milled into nuggets at a lower efficiency than when melted in a Crucible.", GOLD_GRINDING);
        GOLD_PER_INGOT = this.loadPropInt("GoldPerIngot", "Gold nuggets returned when grinding gold tools or armor in a millstone.", GOLD_PER_INGOT);
        NETHERRACK_SYNTHESIS = this.loadPropBool("NetherrackSynthesis", "Allows netherrack to be farbricated from a usable medium, a hellborn plant and some residents from the nether.", NETHERRACK_SYNTHESIS);
        SOULSAND_INFUSION = this.loadPropBool("SoulsandInfusion", "Allows netherrack to be fabricated from dung and experience.", SOULSAND_INFUSION);
        BLAZE_GOLEMS = this.loadPropBool("BlazeGolems", "Allows blazes to be created from a golem-like shape with appropriate blocks.", BLAZE_GOLEMS);
        BLAZE_BREEDING = this.loadPropBool("BlazeBreeding", "Allows blazes to replicate in fire when fed an appropriate item.", BLAZE_BREEDING);
        CROSSBREED_PLANTS = this.loadPropBool("PlantBreeding", "Allows plants to be crossbreed from other plants.", CROSSBREED_PLANTS);
        CROSSBREED_ANIMALS = this.loadPropBool("AnimalBreeding", "Allows animals to be crossbreed from other animals. Disgusting.", CROSSBREED_ANIMALS);
        QUARTZ_GROWING = this.loadPropBool("QuartzSynthesis", "Allows quartz to be grown from silica in appropriate conditions.", QUARTZ_GROWING);
        DUNG_TO_DIRT = this.loadPropBool("DungToDirt", "Allows dung to be turned into dirt by rinsing acids out.", DUNG_TO_DIRT);
        SAND_TO_CLAY = this.loadPropBool("SandToClay", "Allows sand to be turned into clay by adding acidic substances.", SAND_TO_CLAY);
        MELT_HELLFIRE = this.loadPropBool("MeltHellfire", "Allows Blocks of Hellfire to be melted into lava by proximity to it.", MELT_HELLFIRE);
        REDSTONE_BOILING = this.loadPropBool("BoilRedstone", "Allows redstone to be 'boiled' into glowstone by exposure to focused sunlight.", REDSTONE_BOILING);
        EMERALD_PORTAL = this.loadPropBool("EmeraldPortal", "Allows portals to be made from emerald blocks and sacrifice.", EMERALD_PORTAL);
        LILYPADS_SPREAD = this.loadPropBool("LilyPadsSpread", "Allows lilypads to spread.", LILYPADS_SPREAD);
        this.doesNotNeedRestart(() -> {
            DUNG_TO_DIRT_THRESHOLD = this.loadPropInt("DungToDirtThreshold", "The chance for a block of dung to turn into dirt from rinsing. The chance is rand(n) < heat", DUNG_TO_DIRT_THRESHOLD);
            DUNG_TO_DIRT_AMBIENT_TEMP = this.loadPropInt("DungToDirtAmbientTemp", "Amount of ambient temperature is added to the heat value.", DUNG_TO_DIRT_AMBIENT_TEMP);
            BLAZE_BREEDING_DELAY = this.loadPropInt("BlazeBreedingDelay", "Delay between successfully breeding blazes.", BLAZE_BREEDING_DELAY);
            BLAZE_BREEDING_RANGE = this.loadPropInt("BlazeBreedingRange", "Range in blocks to look for fire to birth new blazes in.", BLAZE_BREEDING_RANGE);
            REDSTONE_BOILING_CHANCE = this.loadPropDouble("BoilRedstoneChance", "Chance for redstone to boil into glowstone.", REDSTONE_BOILING_CHANCE, 0.0, 1.0);
            QUARTZ_GROWING_THRESHOLD = this.loadPropInt("QuartzSynthesisThreshold", "Affects the time sand piles must be cooked to make Quartz.", QUARTZ_GROWING_THRESHOLD);
            SOULSAND_INFUSION_THRESHOLD = this.loadPropInt("SoulsandInfusionThreshold", "Amount of exp that must be pushed into a block of dung to create soulsand.", SOULSAND_INFUSION_THRESHOLD);
            MELT_HELLFIRE_THRESHOLD = this.loadPropInt("MeltHellfireThreshold", "The chance for a block of hellfire to melt into a block of lava. The chance is rand(n) < adjacent_lava_blocks", MELT_HELLFIRE_THRESHOLD);
        });
    }

    @Override
    public boolean isActive() {
        return ENABLED;
    }

    @Override
    public void setEnabled(boolean active) {
        ENABLED = active;
        super.setEnabled(active);
    }

    @Override
    public List<Interaction> getDependencies() {
        return Arrays.asList(ModInteractions.bwm);
    }

    @Override
    public void preInit() {
        if (CROSSBREED_PLANTS) {
            MinecraftForge.EVENT_BUS.register((Object)new PlantCrossbreedHandler());
        }
        if (CROSSBREED_ANIMALS) {
            MinecraftForge.EVENT_BUS.register((Object)new AnimalCrossbreedHandler());
        }
        if (REDSTONE_BOILING) {
            MinecraftForge.EVENT_BUS.register((Object)new RedstoneBoilHandler());
        }
        if (SOULSAND_INFUSION) {
            MinecraftForge.EVENT_BUS.register((Object)new SoulSandHandler());
        }
        if (EMERALD_PORTAL) {
            MinecraftForge.EVENT_BUS.register((Object)new PortalHandler());
        }
        if (MELT_HELLFIRE) {
            PatientiaHandler.addCustomBlock(BWMBlocks.AESTHETIC);
        }
        if (CROSSBREED_PLANTS) {
            PatientiaHandler.addCustomBlock(BWMBlocks.FERTILE_FARMLAND);
            PatientiaHandler.addCustomBlock(BWMBlocks.PLANTER);
            PatientiaHandler.addCustomBlock(Blocks.field_150425_aM);
            PatientiaHandler.addCustomBlock(Blocks.field_150377_bs);
        }
        if (LILYPADS_SPREAD) {
            BlockBetterLilyPad lilyPad = new BlockBetterLilyPad();
            ModBlocks.registerBlock((Block)lilyPad, null, false);
            ModItems.registerItem((Item)new ItemBlockLilypad((Block)lilyPad));
        }
        MinecraftForge.EVENT_BUS.register((Object)new RenewablesHandler());
        RenewablesHandler.registerCapability();
    }

    @Override
    void init() {
        PlantCrossbreedHandler.initialize();
        AnimalCrossbreedHandler.initialize();
        OreDictionary.registerOre((String)"listAllBlazeFoods", (Item)Items.field_151044_h);
        OreDictionary.registerOre((String)"listAllBlazeFoods", (ItemStack)new ItemStack(Items.field_151044_h, 1, 1));
        OreDictionary.registerOre((String)"listAllBlazeFoods", (ItemStack)ItemMaterial.getMaterial((ItemMaterial.EnumMaterial)ItemMaterial.EnumMaterial.COAL_DUST));
        OreDictionary.registerOre((String)"listAllBlazeFoods", (ItemStack)ItemMaterial.getMaterial((ItemMaterial.EnumMaterial)ItemMaterial.EnumMaterial.CHARCOAL_DUST));
        OreDictionary.registerOre((String)"listAllBlazeFoods", (ItemStack)ItemMaterial.getMaterial((ItemMaterial.EnumMaterial)ItemMaterial.EnumMaterial.NETHERCOAL));
        OreDictionary.registerOre((String)"listAllBlazeFoods", (ItemStack)ItemMaterial.getMaterial((ItemMaterial.EnumMaterial)ItemMaterial.EnumMaterial.BLASTING_OIL));
        OreDictionary.registerOre((String)"pileSand", (Item)BWMItems.SAND_PILE);
        OreDictionary.registerOre((String)"pileSand", (Item)BWMItems.RED_SAND_PILE);
        OreDictionary.registerOre((String)"pileSand", (Item)ModItems.SOUL_SAND_PILE);
        int axeAmt = ModuleLoader.isFeatureEnabled(CheaperAxes.class) ? 2 : 3;
        ItemStack dungBlock = new ItemStack(BWMBlocks.AESTHETIC, 1, BlockAesthetic.EnumType.DUNG.getMeta());
        ItemStack splitDung = ItemMaterial.getMaterial((ItemMaterial.EnumMaterial)ItemMaterial.EnumMaterial.DUNG, (int)8);
        BWRegistry.CAULDRON.addUnstokedRecipe((List)Lists.newArrayList((Object[])new Ingredient[]{StackIngredient.fromStacks((ItemStack[])new ItemStack[]{ItemMaterial.getMaterial((ItemMaterial.EnumMaterial)ItemMaterial.EnumMaterial.SCOURED_LEATHER)}), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{dungBlock})}), (List)Lists.newArrayList((Object[])new ItemStack[]{ItemMaterial.getMaterial((ItemMaterial.EnumMaterial)ItemMaterial.EnumMaterial.TANNED_LEATHER), splitDung}));
        BWRegistry.CAULDRON.addUnstokedRecipe((List)Lists.newArrayList((Object[])new Ingredient[]{StackIngredient.fromStacks((ItemStack[])new ItemStack[]{ItemMaterial.getMaterial((ItemMaterial.EnumMaterial)ItemMaterial.EnumMaterial.SCOURED_LEATHER_CUT, (int)2)}), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{dungBlock})}), (List)Lists.newArrayList((Object[])new ItemStack[]{ItemMaterial.getMaterial((ItemMaterial.EnumMaterial)ItemMaterial.EnumMaterial.TANNED_LEATHER_CUT, (int)2), splitDung}));
        ItemStack smallRedstone = new ItemStack(Items.field_151137_ax, REDSTONE_PER_SYNTHESIS);
        ItemStack bigRedstone = new ItemStack(Items.field_151137_ax, REDSTONE_PER_SYNTHESIS * 9);
        if (REDSTONE_SYNTHESIS) {
            BWRegistry.CRUCIBLE.addStokedRecipe((List)Lists.newArrayList((Object[])new Ingredient[]{StackIngredient.fromOre((int)1, (String)"nuggetGold"), StackIngredient.fromOre((int)1, (String)"ingotConcentratedHellfire")}), (List)Lists.newArrayList((Object[])new ItemStack[]{smallRedstone})).setPriority(108);
            BWRegistry.CRUCIBLE.addStokedRecipe((List)Lists.newArrayList((Object[])new Ingredient[]{StackIngredient.fromOre((int)1, (String)"ingotGold"), StackIngredient.fromOre((int)1, (String)"ingotConcentratedHellfire")}), (List)Lists.newArrayList((Object[])new ItemStack[]{smallRedstone})).setPriority(109);
            BWRegistry.CRUCIBLE.addStokedRecipe((List)Lists.newArrayList((Object[])new Ingredient[]{StackIngredient.fromOre((int)1, (String)"ingotGold"), StackIngredient.fromOre((int)9, (String)"ingotConcentratedHellfire")}), (List)Lists.newArrayList((Object[])new ItemStack[]{bigRedstone})).setPriority(110);
        }
        if (REDSTONE_SYNTHESIS_EARLY) {
            BWRegistry.MILLSTONE.addMillRecipe((List)Lists.newArrayList((Object[])new Ingredient[]{StackIngredient.fromOre((int)3, (String)"nuggetGold"), StackIngredient.fromOre((int)1, (String)"ingotConcentratedHellfire")}), (List)Lists.newArrayList((Object[])new ItemStack[]{smallRedstone}), SoundEvents.field_189105_bM);
            BWRegistry.MILLSTONE.addMillRecipe((List)Lists.newArrayList((Object[])new Ingredient[]{StackIngredient.fromOre((int)3, (String)"ingotGold"), StackIngredient.fromOre((int)9, (String)"ingotConcentratedHellfire")}), (List)Lists.newArrayList((Object[])new ItemStack[]{bigRedstone}), SoundEvents.field_189105_bM);
        }
        ItemStack hellfireDust = ItemMaterial.getMaterial((ItemMaterial.EnumMaterial)ItemMaterial.EnumMaterial.HELLFIRE_DUST);
        if (HELLFIRE_EARLY) {
            BWRegistry.MILLSTONE.addMillRecipe((List)Lists.newArrayList((Object[])new Ingredient[]{new OreIngredient("dustNetherrack"), new OreIngredient("dustWood")}), (List)Lists.newArrayList((Object[])new ItemStack[]{hellfireDust, ItemMaterial.getMaterial((ItemMaterial.EnumMaterial)ItemMaterial.EnumMaterial.SOUL_DUST)}), SoundEvents.field_189105_bM).setPriority(11);
            BWRegistry.MILLSTONE.addMillRecipe((List)Lists.newArrayList((Object[])new Ingredient[]{new OreIngredient("dustNetherrack")}), (List)Lists.newArrayList((Object[])new ItemStack[]{hellfireDust}), SoundEvents.field_189105_bM).setPriority(10);
        }
        if (BOILING_BUSHES) {
            BWRegistry.CAULDRON.addStokedRecipe(new ItemStack(Blocks.field_150345_g), new ItemStack((Block)Blocks.field_150330_I));
        }
        if (WEAVING_WEBS) {
            BWRegistry.CAULDRON.addUnstokedRecipe((List)Lists.newArrayList((Object[])new Ingredient[]{StackIngredient.fromOre((int)3, (String)"string"), Ingredient.func_193367_a((Item)Items.field_151123_aH)}), new ItemStack(Blocks.field_150321_G));
        }
        if (DIAMOND_RECOVERY) {
            if (ModuleLoader.isFeatureEnabled(HCDiamond.class)) {
                this.addDiamondRecovery((Ingredient)new OreIngredient("ingotDiamond"), 1);
            }
            this.addDiamondRecovery(Ingredient.func_193367_a((Item)Items.field_151048_u), 2);
            this.addDiamondRecovery(Ingredient.func_193367_a((Item)Items.field_151046_w), 3);
            this.addDiamondRecovery(Ingredient.func_193367_a((Item)Items.field_151056_x), axeAmt);
            this.addDiamondRecovery(Ingredient.func_193367_a((Item)Items.field_151047_v), 1);
            this.addDiamondRecovery(Ingredient.func_193367_a((Item)Items.field_151012_L), 2);
            this.addDiamondRecovery(Ingredient.func_193367_a((Item)Items.field_151161_ac), 5);
            this.addDiamondRecovery(Ingredient.func_193367_a((Item)Items.field_151163_ad), 8);
            this.addDiamondRecovery(Ingredient.func_193367_a((Item)Items.field_151173_ae), 7);
            this.addDiamondRecovery(Ingredient.func_193367_a((Item)Items.field_151175_af), 4);
            this.addDiamondRecovery(Ingredient.func_193367_a((Item)ModItems.DIAMOND_SPADE), 2);
            this.addDiamondRecovery(Ingredient.func_193367_a((Item)ModItems.DIAMOND_MATCHPICK), 3);
            this.addDiamondRecovery(Ingredient.func_193367_a((Item)ModItems.DIAMOND_MACHETE), 4);
            this.addDiamondRecovery(Ingredient.func_193367_a((Item)ModItems.DIAMOND_KUKRI), axeAmt + 2);
            this.addDiamondRecovery(Ingredient.func_193367_a((Item)ModItems.DIAMOND_CARPENTER_SAW), axeAmt + 2);
            this.addDiamondRecovery(Ingredient.func_193367_a((Item)ModItems.DIAMOND_MASON_PICK), 4);
        }
        if (LAPIS_FROM_WOOL) {
            this.addLapisRinsing(EnumDyeColor.BLUE, 1, EnumDyeColor.WHITE);
            this.addLapisRinsing(EnumDyeColor.LIGHT_BLUE, 2, EnumDyeColor.WHITE);
            this.addLapisRinsing(EnumDyeColor.CYAN, 2, EnumDyeColor.GREEN);
            this.addLapisRinsing(EnumDyeColor.PURPLE, 2, EnumDyeColor.RED);
            this.addLapisRinsing(EnumDyeColor.MAGENTA, 4, EnumDyeColor.RED, EnumDyeColor.PINK);
        }
        if (GOLD_GRINDING) {
            this.addGoldGrinding(new ItemStack(Items.field_151010_B), 2);
            this.addGoldGrinding(new ItemStack(Items.field_151005_D), 3);
            this.addGoldGrinding(new ItemStack(Items.field_151006_E), axeAmt);
            this.addGoldGrinding(new ItemStack(Items.field_151011_C), 1);
            this.addGoldGrinding(new ItemStack(Items.field_151013_M), 2);
            this.addGoldGrinding(new ItemStack((Item)Items.field_151169_ag), 5);
            this.addGoldGrinding(new ItemStack((Item)Items.field_151171_ah), 8);
            this.addGoldGrinding(new ItemStack((Item)Items.field_151149_ai), 7);
            this.addGoldGrinding(new ItemStack((Item)Items.field_151151_aj), 4);
            this.addGoldGrinding(new ItemStack((Item)ModItems.GOLD_SPADE), 2);
            this.addGoldGrinding(new ItemStack((Item)ModItems.GOLD_MATCHPICK), 3);
            this.addGoldGrinding(new ItemStack((Item)ModItems.GOLD_MACHETE), 4);
            this.addGoldGrinding(new ItemStack((Item)ModItems.GOLD_KUKRI), axeAmt + 2);
            this.addGoldGrinding(new ItemStack((Item)ModItems.GOLD_CARPENTER_SAW), axeAmt + 2);
            this.addGoldGrinding(new ItemStack((Item)ModItems.GOLD_MASON_PICK), 4);
        }
        if (NETHERRACK_SYNTHESIS) {
            ItemStack soulUrn = BlockUrn.getStack((BlockUrn.EnumType)BlockUrn.EnumType.FULL, (int)1);
            BWRegistry.CAULDRON.addUnstokedRecipe((List)Lists.newArrayList((Object[])new Ingredient[]{StackIngredient.fromOre((int)8, (String)"cobblestone"), StackIngredient.fromOre((int)8, (String)"cropNetherWart"), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{soulUrn})}), new ItemStack(Blocks.field_150424_aL, 8));
            BWRegistry.CAULDRON.addUnstokedRecipe((List)Lists.newArrayList((Object[])new Ingredient[]{new OreIngredient("cobblestone"), new OreIngredient("cropNetherWart"), new OreIngredient("dustSoul")}), (List)Lists.newArrayList((Object[])new ItemStack[]{new ItemStack(Blocks.field_150424_aL), ItemMaterial.getMaterial((ItemMaterial.EnumMaterial)ItemMaterial.EnumMaterial.SAWDUST)}));
        }
        if (DIAMOND_SYNTHESIS) {
            BWRegistry.CRUCIBLE.addStokedRecipe((List)Lists.newArrayList((Object[])new Ingredient[]{Ingredient.func_193367_a((Item)Items.field_151073_bk), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack(Items.field_151100_aR, 1, EnumDyeColor.CYAN.func_176767_b())}), new OreIngredient("dustNetherrack")}), (List)Lists.newArrayList((Object[])new ItemStack[]{new ItemStack(Items.field_151045_i), hellfireDust.func_77946_l()}));
        }
        if (QUARTZ_GROWING) {
            BWRegistry.CAULDRON.addRecipe((BulkRecipe)new QuartzCrystalRecipe(Lists.newArrayList((Object[])new Ingredient[]{new OreIngredient("pileSand")}), Lists.newArrayList((Object[])new ItemStack[]{new ItemStack(Items.field_151128_bU)}), 1));
        }
    }

    private void addDiamondRecovery(Ingredient input, int output) {
        ArrayList outputs = Lists.newArrayList((Object[])new ItemStack[]{new ItemStack(Items.field_151045_i, output)});
        if (ModuleLoader.isFeatureEnabled(HCDiamond.class)) {
            outputs.add(new ItemStack(Items.field_151042_j, output));
        }
        BWRegistry.CAULDRON.addStokedRecipe((List)Lists.newArrayList((Object[])new Ingredient[]{input, StackIngredient.fromOre((int)output, (String)"ingotConcentratedHellfire"), StackIngredient.fromOre((int)(output * 8), (String)"dustPotash")}), (List)outputs).setPriority(110);
    }

    private void addGoldGrinding(ItemStack input, int output) {
        int ingots = output * GOLD_PER_INGOT / 9;
        int nuggets = output * GOLD_PER_INGOT % 9;
        ArrayList<ItemStack> outputs = new ArrayList<ItemStack>();
        if (ingots > 0) {
            outputs.add(new ItemStack(Items.field_151043_k, ingots));
        }
        if (nuggets > 0) {
            outputs.add(new ItemStack(Items.field_151074_bl, nuggets));
        }
        BWRegistry.MILLSTONE.addMillRecipe(input, outputs);
    }

    private void addLapisRinsing(EnumDyeColor inputColor, int quantity, EnumDyeColor ... outputColors) {
        StackIngredient soap = StackIngredient.fromStacks((ItemStack[])new ItemStack[]{ItemMaterial.getMaterial((ItemMaterial.EnumMaterial)ItemMaterial.EnumMaterial.SOAP, (int)(2 * quantity))});
        StackIngredient inputWool = StackIngredient.fromStacks((ItemStack[])new ItemStack[]{new ItemStack(Blocks.field_150325_L, quantity * 8, inputColor.func_176765_a())});
        ArrayList<ItemStack> outputStacks = new ArrayList<ItemStack>();
        for (EnumDyeColor color : outputColors) {
            outputStacks.add(new ItemStack(Blocks.field_150325_L, quantity * 8 / outputColors.length, color.func_176765_a()));
        }
        BWRegistry.CAULDRON.addStokedRecipe((List)Lists.newArrayList((Object[])new Ingredient[]{inputWool, soap}), new ArrayList(outputStacks)).setPriority(10);
        outputStacks.add(new ItemStack(Items.field_151100_aR, 1, EnumDyeColor.BLUE.func_176767_b()));
        BWRegistry.CAULDRON.addStokedRecipe((List)Lists.newArrayList((Object[])new Ingredient[]{inputWool, soap, Ingredient.func_193367_a((Item)Items.field_151119_aD)}), outputStacks).setPriority(11);
    }
}

