/*
 * Decompiled with CFR 0.152.
 */
package betterwithaddons.handler;

import betterwithaddons.interaction.InteractionWheat;
import betterwithaddons.item.ModItems;
import com.google.common.collect.ImmutableList;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.Item;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class WheatHandler {
    static Field toolMaterialField;

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void harvestBlock(BlockEvent.HarvestDropsEvent event) {
        if (!InteractionWheat.REPLACE_WHEAT_DROPS) {
            return;
        }
        IBlockState state = event.getState();
        if (state.func_177230_c() != Blocks.field_150464_aj) {
            return;
        }
        List drops = event.getDrops();
        if (drops instanceof ImmutableList) {
            return;
        }
        ListIterator<ItemStack> iterator = drops.listIterator();
        while (iterator.hasNext()) {
            ItemStack stack = (ItemStack)iterator.next();
            if (stack.func_77973_b() == Items.field_151015_O) {
                iterator.set(ModItems.MATERIAL_WHEAT.getMaterial("hay", stack.func_190916_E()));
            }
            if (stack.func_77973_b() != Items.field_151014_N) continue;
            iterator.set(new ItemStack(Items.field_151015_O, stack.func_190916_E()));
        }
    }

    @SubscribeEvent
    public static void breakSpeed(PlayerEvent.BreakSpeed event) {
        EntityPlayer player;
        if (!InteractionWheat.DIG_UP_CROPS) {
            return;
        }
        if (toolMaterialField == null) {
            toolMaterialField = ReflectionHelper.findField(ItemHoe.class, (String[])new String[]{"field_77843_a", "toolMaterial"});
        }
        if ((player = event.getEntityPlayer()) == null) {
            return;
        }
        IBlockState state = event.getState();
        Block block = state.func_177230_c();
        ItemStack tool = player.func_184614_ca();
        if (tool.func_77973_b() instanceof ItemHoe && "hoe".equals(block.getHarvestTool(state))) {
            try {
                Item.ToolMaterial material = (Item.ToolMaterial)toolMaterialField.get(tool.func_77973_b());
                if (material != null) {
                    event.setNewSpeed(event.getNewSpeed() * material.func_77998_b());
                }
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }

    @SubscribeEvent
    public static void villagerFix(LivingEvent.LivingUpdateEvent event) {
        if (!InteractionWheat.REPLACE_WHEAT_DROPS) {
            return;
        }
        if (event.getEntityLiving().func_130014_f_().field_72995_K) {
            return;
        }
        if (event.getEntityLiving() instanceof EntityVillager) {
            EntityVillager villager = (EntityVillager)event.getEntityLiving();
            InventoryBasic inventory = villager.func_175551_co();
            ArrayList<ItemStack> itemstacks_created = new ArrayList<ItemStack>();
            for (int i = 0; i < inventory.func_70302_i_(); ++i) {
                ItemStack itemstack = inventory.func_70301_a(i);
                if (itemstack.func_190926_b()) continue;
                Item item = itemstack.func_77973_b();
                if (item == Items.field_151015_O && itemstack.func_190916_E() >= 6) {
                    int wheat_consumed = itemstack.func_190916_E() / 2 / 3 * 3;
                    int bread_produced = wheat_consumed / 2;
                    int seeds_produced = wheat_consumed / 2;
                    itemstack.func_190918_g(wheat_consumed);
                    itemstacks_created.add(new ItemStack(Items.field_151025_P, bread_produced, 0));
                    itemstacks_created.add(new ItemStack(Items.field_151014_N, seeds_produced, 0));
                    if (InteractionWheat.THRESH_WHEAT) {
                        itemstacks_created.add(ModItems.MATERIAL_WHEAT.getMaterial("hay", wheat_consumed));
                    }
                }
                inventory.func_70299_a(i, itemstack);
            }
            for (ItemStack stack : itemstacks_created) {
                double y = villager.field_70163_u - 0.3 + (double)villager.func_70047_e();
                EntityItem entityitem = new EntityItem(villager.field_70170_p, villager.field_70165_t, y, villager.field_70161_v, stack);
                entityitem.func_174869_p();
                villager.field_70170_p.func_72838_d((Entity)entityitem);
            }
        }
    }
}

