/*
 * Decompiled with CFR 0.152.
 */
package betterwithaddons.handler;

import betterwithaddons.handler.MobTerritory;
import betterwithaddons.handler.MobTerritoryType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.storage.WorldSavedData;

public class TerratorialData
extends WorldSavedData {
    public static final String ID = "TerratorialData";
    private HashMap<Integer, MobTerritory> territories = new HashMap();
    private HashMap<ChunkPos, MobTerritory> territoryChunks = new HashMap();
    private int currentMaxID = 0;

    public TerratorialData(String name) {
        super(name);
    }

    public TerratorialData() {
        this(ID);
    }

    public void func_76184_a(NBTTagCompound nbt) {
        int i;
        NBTTagList territorylist = nbt.func_150295_c("territoryChunks", 10);
        NBTTagList chunks = nbt.func_150295_c("territoryChunks", 10);
        for (i = 0; i < territorylist.func_74745_c(); ++i) {
            NBTTagCompound territorycompound = territorylist.func_150305_b(i);
            int territoryid = territorycompound.func_74762_e("id");
            String typeid = territorycompound.func_74779_i("type");
            ItemStack bannerstack = new ItemStack(territorycompound.func_74775_l("banner"));
            if (MobTerritoryType.typeList.containsKey(typeid)) {
                MobTerritory territory = new MobTerritory(territoryid, MobTerritoryType.typeList.get(typeid));
                territory.setBanner(bannerstack);
                this.territories.put(territoryid, territory);
            }
            this.currentMaxID = Math.max(this.currentMaxID, territoryid);
        }
        ++this.currentMaxID;
        for (i = 0; i < chunks.func_74745_c(); ++i) {
            NBTTagCompound chunkcompound = chunks.func_150305_b(i);
            ChunkPos chunkpos = new ChunkPos(chunkcompound.func_74762_e("chunkX"), chunkcompound.func_74762_e("chunkZ"));
            int territoryid = chunkcompound.func_74762_e("id");
            if (!this.territories.containsKey(territoryid)) continue;
            this.territoryChunks.put(chunkpos, this.territories.get(territoryid));
        }
    }

    public NBTTagCompound func_189551_b(NBTTagCompound nbt) {
        NBTTagList territorylist = new NBTTagList();
        NBTTagList chunklist = new NBTTagList();
        ArrayList<MobTerritory> hasNoTerritory = new ArrayList<MobTerritory>(this.territories.values());
        for (Map.Entry<ChunkPos, MobTerritory> entry : this.territoryChunks.entrySet()) {
            NBTTagCompound chunkcompound = new NBTTagCompound();
            ChunkPos chunkpos = entry.getKey();
            MobTerritory territory = entry.getValue();
            chunkcompound.func_74768_a("chunkX", chunkpos.field_77276_a);
            chunkcompound.func_74768_a("chunkZ", chunkpos.field_77275_b);
            chunkcompound.func_74768_a("territoryid", territory.getId());
            territorylist.func_74742_a((NBTBase)chunkcompound);
            if (!hasNoTerritory.contains(territory)) continue;
            hasNoTerritory.remove(territory);
        }
        for (Map.Entry<Object, MobTerritory> entry : this.territories.entrySet()) {
            MobTerritory territory = entry.getValue();
            if (hasNoTerritory.contains(territory)) continue;
            NBTTagCompound territorycompound = new NBTTagCompound();
            territorycompound.func_74768_a("id", territory.getId());
            territorycompound.func_74778_a("type", territory.getTerritoryType().getIdentifier());
            territorycompound.func_74782_a("banner", (NBTBase)territory.getBanner().serializeNBT());
            territorylist.func_74742_a((NBTBase)territorycompound);
        }
        nbt.func_74782_a("territoryChunks", (NBTBase)chunklist);
        nbt.func_74782_a("territories", (NBTBase)territorylist);
        return nbt;
    }

    public void addTerritory(MobTerritory territory) {
        this.territories.put(territory.getId(), territory);
        this.func_76185_a();
    }

    public void removeTerritory(MobTerritory territory) {
        Iterator<Map.Entry<ChunkPos, MobTerritory>> it = this.territoryChunks.entrySet().iterator();
        while (it.hasNext()) {
            if (it.next().getValue() != territory) continue;
            it.remove();
        }
        this.func_76185_a();
    }

    public void claimChunk(MobTerritory territory, ChunkPos chunkpos) {
        if (this.territories.containsValue(territory) && !this.territoryChunks.containsKey(chunkpos)) {
            this.territoryChunks.put(chunkpos, territory);
            this.func_76185_a();
        }
    }

    public void unclaimChunk(ChunkPos chunkpos) {
        if (this.territoryChunks.containsKey(chunkpos)) {
            this.territoryChunks.remove(chunkpos);
            this.func_76185_a();
        }
    }

    public static TerratorialData getInstance(World world) {
        if (world != null) {
            WorldSavedData handler = world.getPerWorldStorage().func_75742_a(TerratorialData.class, ID);
            if (handler == null) {
                handler = new TerratorialData();
                world.getPerWorldStorage().func_75745_a(ID, handler);
            }
            return (TerratorialData)handler;
        }
        return null;
    }
}

