/*
 * Decompiled with CFR 0.152.
 */
package betterwithaddons.handler;

import betterwithaddons.util.EntityUtil;
import betterwithmods.common.BWMBlocks;
import betterwithmods.common.blocks.BlockAesthetic;
import java.util.Random;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ButcherHandler {
    @SubscribeEvent
    public void playerTick(LivingAttackEvent attackEvent) {
        Entity target = attackEvent.getEntity();
        Entity source = attackEvent.getSource().func_76364_f();
        if (source instanceof EntityLivingBase) {
            IBlockState state;
            EntityLivingBase attacker = (EntityLivingBase)source;
            if (target == null) {
                return;
            }
            World world = attacker.func_130014_f_();
            BlockPos pos = EntityUtil.getEntityFloor(target, 2);
            if (!world.field_72995_K && this.isChopBlock(state = world.func_180495_p(pos)) && this.isSuitableWeapon(attacker.func_184614_ca())) {
                attacker.func_70690_d(new PotionEffect(MobEffects.field_76420_g, 200));
                attacker.func_70690_d(new PotionEffect(MobEffects.field_76438_s, 200));
                this.splatter(world, pos, 1);
            }
        }
    }

    private boolean isSuitableWeapon(ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        Item item = stack.func_77973_b();
        return item.getToolClasses(stack).contains("axe") || item instanceof ItemSword || item instanceof ItemAxe;
    }

    private boolean isChopBlock(IBlockState state) {
        return state.func_177230_c() == BWMBlocks.AESTHETIC && (state.func_177229_b((IProperty)BlockAesthetic.TYPE) == BlockAesthetic.EnumType.CHOPBLOCK || state.func_177229_b((IProperty)BlockAesthetic.TYPE) == BlockAesthetic.EnumType.CHOPBLOCKBLOOD);
    }

    private void splatter(World world, BlockPos pos, int radius) {
        Random rand = world.field_73012_v;
        for (int x = -radius; x <= radius; ++x) {
            for (int y = -radius; y <= radius; ++y) {
                for (int z = -radius; z <= radius; ++z) {
                    BlockPos splatterpos = pos.func_177982_a(x, y, z);
                    if (rand.nextInt(3) != 0 || !this.isChopBlock(world.func_180495_p(splatterpos))) continue;
                    world.func_175656_a(splatterpos, BWMBlocks.AESTHETIC.func_176223_P().func_177226_a((IProperty)BlockAesthetic.TYPE, (Comparable)BlockAesthetic.EnumType.CHOPBLOCKBLOOD));
                }
            }
        }
    }
}

