/*
 * Decompiled with CFR 0.152.
 */
package betterwithaddons.entity;

import betterwithaddons.item.ModItems;
import betterwithaddons.tileentity.TileEntityLegendarium;
import com.google.common.base.Optional;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.items.IItemHandler;

public class EntityArtifactFrame
extends EntityItemFrame
implements IEntityAdditionalSpawnData {
    private static final String TAG_FACINGDIRECTION = "Facing";
    private static final DataParameter<Optional<BlockPos>> LINKPOS = EntityDataManager.func_187226_a(EntityArtifactFrame.class, (DataSerializer)DataSerializers.field_187201_k);
    private static final DataParameter<Integer> SLOT = EntityDataManager.func_187226_a(EntityArtifactFrame.class, (DataSerializer)DataSerializers.field_187192_b);

    public EntityArtifactFrame(World worldIn, BlockPos pos, EnumFacing facing) {
        super(worldIn, pos, facing);
    }

    public EntityArtifactFrame(World worldIn) {
        super(worldIn);
    }

    public TileEntityLegendarium getLegendarium() {
        TileEntity tile;
        BlockPos linkPos = this.getLinkPos();
        if (linkPos != null && (tile = this.field_70170_p.func_175625_s(linkPos)) instanceof TileEntityLegendarium) {
            return (TileEntityLegendarium)tile;
        }
        return null;
    }

    public BlockPos getLinkPos() {
        return (BlockPos)((Optional)this.func_184212_Q().func_187225_a(LINKPOS)).orNull();
    }

    public int getSlot() {
        return (Integer)this.func_184212_Q().func_187225_a(SLOT);
    }

    public TileEntityLegendarium.CanvasType getCanvasType() {
        TileEntityLegendarium legendarium = this.getLegendarium();
        if (legendarium != null) {
            return legendarium.getCanvasType();
        }
        return TileEntityLegendarium.CanvasType.Normal;
    }

    public void link(TileEntityLegendarium tile, int slot) {
        this.setLinkPos(tile.func_174877_v());
        this.setSlot(slot);
    }

    public void unlink() {
        this.setLinkPos(null);
        this.setSlot(0);
    }

    public void setSlot(int slot) {
        this.func_184212_Q().func_187227_b(SLOT, (Object)slot);
    }

    public void setLinkPos(BlockPos pos) {
        this.func_184212_Q().func_187227_b(LINKPOS, (Object)Optional.fromNullable((Object)pos));
    }

    public boolean func_190530_aW() {
        return this.isLinked() || super.func_190530_aW();
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(LINKPOS, (Object)Optional.absent());
        this.func_184212_Q().func_187214_a(SLOT, (Object)0);
    }

    public ItemStack getArtifact() {
        TileEntityLegendarium legendarium = this.getLegendarium();
        if (legendarium != null) {
            IItemHandler inventory = legendarium.getInventory();
            if (inventory.getSlots() > this.getSlot()) {
                ItemStack stack = inventory.getStackInSlot(this.getSlot()).func_77946_l();
                return stack;
            }
            return ItemStack.field_190927_a;
        }
        return ItemStack.field_190927_a;
    }

    public void func_70071_h_() {
        ItemStack displayStack;
        ItemStack stack;
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K && !ItemStack.func_77989_b((ItemStack)(stack = this.getArtifact()), (ItemStack)(displayStack = this.func_82335_i()))) {
            this.func_82334_a(stack);
        }
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        if (!this.func_82335_i().func_190926_b()) {
            if (!this.field_70170_p.field_72995_K && !source.func_94541_c()) {
                this.func_184185_a(SoundEvents.field_187692_g, 0.2f, 1.5f);
            }
            return false;
        }
        if (!this.field_70128_L && !this.field_70170_p.field_72995_K) {
            this.func_70106_y();
            this.func_70018_K();
            this.func_110128_b(source.func_76364_f());
        }
        return true;
    }

    public void func_146065_b(Entity entityIn, boolean dropFrame) {
        if (!dropFrame) {
            super.func_146065_b(entityIn, false);
            return;
        }
        if (this.func_130014_f_().func_82736_K().func_82766_b("doEntityDrops")) {
            this.dropFrame();
        }
    }

    protected void dropFrame() {
        this.func_70099_a(new ItemStack((Item)ModItems.ARTIFACT_FRAME, 1), 0.0f);
    }

    public boolean func_184230_a(EntityPlayer player, EnumHand hand) {
        return true;
    }

    public int func_174866_q() {
        return this.func_82335_i().func_190926_b() ? 0 : 15;
    }

    public void func_70014_b(NBTTagCompound compound) {
        compound.func_74774_a(TAG_FACINGDIRECTION, (byte)this.field_174860_b.func_176736_b());
        if (this.getLinkPos() != null) {
            compound.func_74768_a("LinkX", this.getLinkPos().func_177958_n());
            compound.func_74768_a("LinkY", this.getLinkPos().func_177956_o());
            compound.func_74768_a("LinkZ", this.getLinkPos().func_177952_p());
        }
        compound.func_74768_a("Slot", this.getSlot());
        super.func_70014_b(compound);
    }

    public void func_70037_a(NBTTagCompound compound) {
        this.func_174859_a(EnumFacing.func_176731_b((int)compound.func_74771_c(TAG_FACINGDIRECTION)));
        if (compound.func_74764_b("LinkX")) {
            this.setLinkPos(new BlockPos(compound.func_74762_e("LinkX"), compound.func_74762_e("LinkY"), compound.func_74762_e("LinkZ")));
        }
        this.setSlot(compound.func_74762_e("Slot"));
        super.func_70037_a(compound);
    }

    public void writeSpawnData(ByteBuf buffer) {
        buffer.writeShort(this.field_174860_b.func_176736_b());
    }

    public void readSpawnData(ByteBuf additionalData) {
        this.func_174859_a(EnumFacing.func_176731_b((int)additionalData.readShort()));
    }

    public boolean isLinked() {
        TileEntityLegendarium legendarium = this.getLegendarium();
        return legendarium != null;
    }
}

