/*
 * Decompiled with CFR 0.152.
 */
package betterwithaddons.crafting.recipes;

import betterwithaddons.interaction.InteractionBWR;
import betterwithaddons.item.ModItems;
import betterwithaddons.util.ItemUtil;
import betterwithmods.common.registry.bulk.recipes.CookingPotRecipe;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockTrapDoor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.items.ItemStackHandler;

public class QuartzCrystalRecipe
extends CookingPotRecipe {
    public QuartzCrystalRecipe(@Nonnull List<Ingredient> inputs, @Nonnull List<ItemStack> outputs, int heat) {
        super(inputs, outputs, heat);
    }

    public NonNullList<ItemStack> onCraft(World world, TileEntity tile, ItemStackHandler inv) {
        NonNullList result = NonNullList.func_191196_a();
        Random random = world.field_73012_v;
        BlockPos pos = tile.func_174877_v();
        BlockPos lidpos = pos.func_177984_a();
        IBlockState state = world.func_180495_p(pos);
        IBlockState lidstate = world.func_180495_p(lidpos);
        int lidstrength = this.getLidStrength(world, lidpos, lidstate);
        int totalsouls = 0;
        boolean lidOn = lidstrength > -1;
        for (int i = 0; i < inv.getSlots(); ++i) {
            ItemStack stack = inv.getStackInSlot(i);
            if (stack.func_190926_b() || !ItemUtil.matchesOreDict(stack, "pileSand")) continue;
            boolean producesSouls = stack.func_77973_b() == ModItems.SOUL_SAND_PILE;
            NBTTagCompound compound = stack.func_77978_p();
            if (compound != null && compound.func_74764_b("QuartzCrystal")) {
                int growth = compound.func_74762_e("QuartzCrystalGrowth");
                int souls = compound.func_74762_e("QuartzSouls");
                if (lidOn) {
                    if (growth >= InteractionBWR.QUARTZ_GROWING_THRESHOLD) {
                        result.add((Object)new ItemStack(Items.field_151128_bU, stack.func_190916_E()));
                        stack.func_190918_g(1);
                    } else {
                        compound.func_74768_a("QuartzCrystalGrowth", growth + 1);
                        if (producesSouls) {
                            totalsouls += souls;
                            compound.func_74768_a("QuartzSouls", souls + 1);
                        }
                    }
                } else if (producesSouls) {
                    compound.func_74768_a("QuartzSouls", 0);
                }
                inv.setStackInSlot(i, stack);
                continue;
            }
            ItemStack crystal = new ItemStack(stack.func_77973_b(), 1, stack.func_77960_j());
            NBTTagCompound newcompound = new NBTTagCompound();
            newcompound.func_74768_a("QuartzCrystal", random.nextInt());
            newcompound.func_74768_a("QuartzCrystalGrowth", 0);
            newcompound.func_74768_a("QuartzSouls", 0);
            crystal.func_77982_d(newcompound);
            result.add((Object)crystal);
            stack.func_190918_g(1);
            inv.setStackInSlot(i, stack);
        }
        if (totalsouls > 27) {
            world.func_175698_g(pos);
            world.func_72876_a(null, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, 2.0f, true);
        }
        if (lidstrength == 0) {
            world.func_175698_g(lidpos);
        }
        if (lidstrength > 0 && lidstrength < 3) {
            world.func_175655_b(lidpos, lidstrength > 1);
        }
        return result;
    }

    private int getLidStrength(World world, BlockPos pos, IBlockState state) {
        Block block = state.func_177230_c();
        if (state.isSideSolid((IBlockAccess)world, pos, EnumFacing.DOWN) || block instanceof BlockTrapDoor && !((Boolean)state.func_177229_b((IProperty)BlockTrapDoor.field_176283_b)).booleanValue() && state.func_177229_b((IProperty)BlockTrapDoor.field_176285_M) == BlockTrapDoor.DoorHalf.BOTTOM) {
            Material material = state.func_185904_a();
            float hardness = state.func_185887_b(world, pos);
            if (material.func_76224_d() || material.func_76222_j()) {
                return 0;
            }
            if (hardness < 1.5f || material.func_76217_h()) {
                return 1;
            }
            if (hardness < 5.0f) {
                return 2;
            }
            return 3;
        }
        return -1;
    }
}

