/*
 * Decompiled with CFR 0.152.
 */
package betterwithaddons.container;

import betterwithaddons.block.BlockWritingTable;
import betterwithaddons.interaction.InteractionBTWTweak;
import betterwithaddons.item.ModItems;
import betterwithaddons.util.ItemUtil;
import betterwithmods.common.registry.block.recipe.IngredientSpecial;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.inventory.InventoryCraftResult;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemNameTag;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import org.apache.commons.lang3.StringUtils;

public class ContainerRename
extends Container {
    private World world;
    private BlockPos pos;
    private IInventory outputSlot;
    private IInventory inputSlots;
    private String repairedItemName;
    public int cost;
    private Ingredient paperMatch;
    private Ingredient inkMatch;

    public ContainerRename(EntityPlayer player, World world, int x, int y, int z) {
        this.pos = new BlockPos(x, y, z);
        this.world = world;
        this.outputSlot = new InventoryCraftResult();
        this.inputSlots = new InventoryBasic("Rename", true, 3){

            public void func_70296_d() {
                super.func_70296_d();
                ContainerRename.this.func_75130_a((IInventory)this);
            }
        };
        this.func_75146_a(new Slot(this.inputSlots, 0, 38, 46));
        this.func_75146_a(new Slot(this.inputSlots, 1, 60, 37));
        this.func_75146_a(new Slot(this.inputSlots, 2, 60, 55));
        this.func_75146_a(new Slot(this.outputSlot, 3, 118, 46){

            public boolean func_75214_a(ItemStack stack) {
                return false;
            }

            public boolean func_82869_a(EntityPlayer playerIn) {
                return (playerIn.field_71075_bZ.field_75098_d || playerIn.field_71068_ca >= ContainerRename.this.cost) && this.func_75216_d();
            }

            public ItemStack func_190901_a(EntityPlayer thePlayer, ItemStack stack) {
                if (!thePlayer.field_71075_bZ.field_75098_d) {
                    thePlayer.func_82242_a(-ContainerRename.this.cost);
                }
                ItemStack quill = ContainerRename.this.inputSlots.func_70301_a(1);
                quill.func_77972_a(1, (EntityLivingBase)thePlayer);
                ContainerRename.this.inputSlots.func_70299_a(0, ItemStack.field_190927_a);
                ContainerRename.this.inputSlots.func_70299_a(1, quill);
                ContainerRename.this.inputSlots.func_70298_a(2, 1);
                return stack;
            }
        });
        this.bindPlayerInventory((IItemHandler)player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null));
        this.paperMatch = new IngredientSpecial(stack -> stack.func_77973_b() instanceof ItemNameTag || ItemUtil.matchesOreDict(stack, "paper"));
        this.inkMatch = Ingredient.func_193367_a((Item)ModItems.INK_AND_QUILL);
    }

    protected void bindPlayerInventory(IItemHandler inventoryPlayer) {
        int i;
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a((Slot)new SlotItemHandler(inventoryPlayer, j + i * 9 + 9, 8 + j * 18, 86 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.func_75146_a((Slot)new SlotItemHandler(inventoryPlayer, i, 8 + i * 18, 144));
        }
    }

    public boolean func_75145_c(EntityPlayer player) {
        if (this.world.func_180495_p(this.pos).func_177230_c() instanceof BlockWritingTable) {
            return player.func_70092_e((double)this.pos.func_177958_n() + 0.5, (double)this.pos.func_177956_o() + 0.5, (double)this.pos.func_177952_p() + 0.5) <= 64.0;
        }
        return false;
    }

    public void func_75130_a(IInventory inventoryIn) {
        super.func_75130_a(inventoryIn);
        if (inventoryIn == this.inputSlots) {
            this.updateRepairOutput();
        }
    }

    public void updateRepairOutput() {
        ItemStack inputStack = this.inputSlots.func_70301_a(0);
        ItemStack inkStack = this.inputSlots.func_70301_a(1);
        ItemStack paperStack = this.inputSlots.func_70301_a(2);
        if (!this.paperMatch.apply(paperStack) || !this.inkMatch.apply(inkStack) || inputStack.func_77973_b() instanceof ItemNameTag) {
            this.outputSlot.func_70299_a(0, ItemStack.field_190927_a);
            this.cost = 0;
        } else {
            ItemStack outputStack = inputStack.func_77946_l();
            this.cost = InteractionBTWTweak.WRITING_TABLE_COST;
            boolean blank = StringUtils.isBlank((CharSequence)this.repairedItemName);
            if (inputStack.func_190926_b() && !blank) {
                outputStack = paperStack.func_77973_b() instanceof ItemNameTag ? paperStack.func_77946_l() : new ItemStack(Items.field_151057_cb);
                outputStack.func_151001_c(this.repairedItemName);
            } else if (blank && inputStack.func_82837_s()) {
                outputStack.func_135074_t();
            } else if (!blank && !this.repairedItemName.equals(inputStack.func_82833_r())) {
                outputStack.func_151001_c(this.repairedItemName);
            } else {
                outputStack = ItemStack.field_190927_a;
                this.cost = 0;
            }
            this.outputSlot.func_70299_a(0, outputStack);
        }
        this.func_75142_b();
    }

    public void func_75134_a(EntityPlayer playerIn) {
        super.func_75134_a(playerIn);
        if (!this.world.field_72995_K) {
            this.func_193327_a(playerIn, this.world, this.inputSlots);
        }
    }

    public ItemStack func_82846_b(EntityPlayer playerIn, int index) {
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            if (index == 3) {
                if (!this.func_75135_a(itemstack1, 4, 40, true)) {
                    return ItemStack.field_190927_a;
                }
                slot.func_75220_a(itemstack1, itemstack);
            } else if (index < 0 || index > 3 ? index >= 4 && index < 40 && !this.func_75135_a(itemstack1, 0, 3, false) : !this.func_75135_a(itemstack1, 4, 40, false)) {
                return ItemStack.field_190927_a;
            }
            if (itemstack1.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (itemstack1.func_190916_E() == itemstack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(playerIn, itemstack1);
        }
        return itemstack;
    }

    public void updateItemName(String newName) {
        this.repairedItemName = newName;
        if (this.func_75139_a(3).func_75216_d()) {
            ItemStack itemstack = this.func_75139_a(3).func_75211_c();
            if (StringUtils.isBlank((CharSequence)newName)) {
                itemstack.func_135074_t();
            } else {
                itemstack.func_151001_c(this.repairedItemName);
            }
        }
        this.updateRepairOutput();
    }

    public void func_75132_a(IContainerListener listener) {
        super.func_75132_a(listener);
        listener.func_71112_a((Container)this, 0, this.cost);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_75137_b(int id, int data) {
        if (id == 0) {
            this.cost = data;
        }
    }
}

