/*
 * Decompiled with CFR 0.152.
 */
package betterwithaddons.block;

import betterwithaddons.block.BlockBase;
import betterwithaddons.util.ISpecialMeasuringBehavior;
import betterwithaddons.util.InventoryUtil;
import java.util.HashMap;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.SoundEvents;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public abstract class BlockWeight
extends BlockBase {
    public static final HashMap<Block, ISpecialMeasuringBehavior> SPECIAL_BEHAVIOR = new HashMap();
    public static final PropertyBool ACTIVE = PropertyBool.func_177716_a((String)"active");

    protected BlockWeight(String name) {
        super(name, Material.field_151575_d);
        this.func_149711_c(1.5f);
        this.func_149675_a(true);
        this.func_180632_j(this.func_176223_P().func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf(false)));
    }

    public static void addSpecialMeasuringBehavior(Block block, ISpecialMeasuringBehavior behavior) {
        SPECIAL_BEHAVIOR.put(block, behavior);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        worldIn.func_175684_a(pos, (Block)this, 1);
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        int nextMeasureCycle = this.measureBlock(worldIn, pos, worldIn.func_180495_p(pos));
        worldIn.func_175684_a(pos, (Block)this, nextMeasureCycle);
    }

    public int measureBlock(World world, BlockPos pos, IBlockState state) {
        BlockPos checkpos = pos.func_177984_a();
        IBlockState checkstate = world.func_180495_p(checkpos);
        TileEntity te = world.func_175625_s(checkpos);
        boolean isFull = true;
        boolean isEmpty = true;
        int delay = 20;
        if (te != null) {
            boolean foundAnyMeasurable = false;
            for (EnumFacing facing : EnumFacing.field_82609_l) {
                if (te.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing)) {
                    IItemHandler inventory = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing);
                    if (!InventoryUtil.isEmpty(inventory)) {
                        isEmpty = false;
                    }
                    if (!InventoryUtil.isFull(inventory)) {
                        isFull = false;
                    }
                    foundAnyMeasurable = true;
                }
                if (!te.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facing)) continue;
                IFluidHandler tank = (IFluidHandler)te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facing);
                FluidStack fluid = tank.drain(Integer.MAX_VALUE, false);
                if (fluid != null && tank.fill(fluid, false) > 0) {
                    isFull = false;
                }
                if (fluid != null && fluid.amount != 0) {
                    isEmpty = false;
                }
                foundAnyMeasurable = true;
            }
            if (foundAnyMeasurable) {
                delay = 1;
            } else {
                isFull = false;
            }
        } else if (SPECIAL_BEHAVIOR.containsKey(checkstate.func_177230_c())) {
            ISpecialMeasuringBehavior behavior = SPECIAL_BEHAVIOR.get(checkstate.func_177230_c());
            isEmpty = behavior.isEmpty(world, checkpos, checkstate);
            isFull = behavior.isFull(world, checkpos, checkstate);
            delay = behavior.getDelay(world, checkpos, checkstate);
        } else {
            isFull = false;
        }
        boolean active = this.decideActivity(isEmpty, isFull);
        if (active != (Boolean)state.func_177229_b((IProperty)ACTIVE)) {
            world.func_175656_a(pos, state.func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf(active)));
            float f = active ? 0.6f : 0.5f;
            world.func_184133_a(null, pos, SoundEvents.field_187750_dc, SoundCategory.BLOCKS, 1.0f, f);
        }
        return delay;
    }

    public abstract boolean decideActivity(boolean var1, boolean var2);

    public int func_180656_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return (Boolean)blockState.func_177229_b((IProperty)ACTIVE) != false ? 15 : 0;
    }

    public boolean func_149744_f(IBlockState state) {
        return true;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf(meta > 0));
    }

    public int func_176201_c(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)ACTIVE) != false ? 1 : 0;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{ACTIVE});
    }

    public boolean canPlaceTorchOnTop(IBlockState state, IBlockAccess world, BlockPos pos) {
        return true;
    }

    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing face) {
        return face.func_176740_k() == EnumFacing.Axis.Y ? BlockFaceShape.SOLID : BlockFaceShape.UNDEFINED;
    }
}

