/*
 * Decompiled with CFR 0.152.
 */
package betterwithaddons.block;

import betterwithaddons.BetterWithAddons;
import betterwithaddons.block.BlockRopeSideways;
import betterwithaddons.block.ModBlocks;
import betterwithaddons.tileentity.TileEntityRopePost;
import betterwithaddons.util.ItemUtil;
import betterwithmods.api.block.PropertyObject;
import betterwithmods.common.BWMBlocks;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFence;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ChunkCache;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;

public class BlockRopePost
extends BlockFence {
    public static final PropertyBool HAS_PLANKS = PropertyBool.func_177716_a((String)"has_planks");
    public static final PropertyBool HAS_POST = PropertyBool.func_177716_a((String)"has_post");
    public static final PropertyObject<ItemStack> HELD_PLANKS = new PropertyObject("held_planks", ItemStack.class);
    public static final PropertyObject<IBlockAccess> HELD_WORLD = new PropertyObject("held_world", IBlockAccess.class);
    public static final PropertyObject<BlockPos> HELD_POS = new PropertyObject("held_pos", BlockPos.class);
    public static final PropertyObject<IBlockState> HELD_STATE = new PropertyObject("held_state", IBlockState.class);
    private static AxisAlignedBB AABB_POST = new AxisAlignedBB(0.375, 0.0, 0.375, 0.625, 1.0, 0.625);
    private static AxisAlignedBB AABB_PLATFORM = new AxisAlignedBB(0.0, 0.75, 0.0, 1.0, 1.0, 1.0);

    public BlockRopePost(String name) {
        super(Material.field_151575_d, MapColor.field_151663_o);
        this.setRegistryName(new ResourceLocation("betterwithaddons", name));
        this.func_149663_c(name);
        this.func_149647_a(BetterWithAddons.instance.creativeTab);
        this.func_180632_j(this.func_176223_P().func_177226_a((IProperty)HAS_PLANKS, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)HAS_POST, (Comparable)Boolean.valueOf(false)));
        this.func_149711_c(0.5f);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        if (((Boolean)state.func_177229_b((IProperty)HAS_PLANKS)).booleanValue()) {
            return field_185505_j;
        }
        return AABB_POST;
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean p_185477_7_) {
        if (((Boolean)state.func_177229_b((IProperty)HAS_PLANKS)).booleanValue()) {
            BlockRopePost.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)AABB_POST);
            BlockRopePost.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)AABB_PLATFORM);
        } else {
            BlockRopePost.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)field_185671_f);
        }
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEntityRopePost();
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public float func_176195_g(IBlockState blockState, World worldIn, BlockPos pos) {
        TileEntity te;
        if (((Boolean)blockState.func_177229_b((IProperty)HAS_PLANKS)).booleanValue()) {
            return 2.0f;
        }
        if (((Boolean)blockState.func_177229_b((IProperty)HAS_POST)).booleanValue() && (te = worldIn.func_175625_s(pos)) instanceof TileEntityRopePost) {
            IBlockState state = ((TileEntityRopePost)te).getFenceState();
            return state.func_185887_b(worldIn, pos);
        }
        return super.func_176195_g(blockState, worldIn, pos);
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        TileEntity te;
        if (((Boolean)state.func_177229_b((IProperty)HAS_PLANKS)).booleanValue() && (te = world.func_175625_s(pos)) instanceof TileEntityRopePost && !world.field_72995_K) {
            TileEntityRopePost tile = (TileEntityRopePost)te;
            BlockRopePost.func_180635_a((World)world, (BlockPos)pos, (ItemStack)tile.getPlanks());
            tile.setPlanks(ItemStack.field_190927_a);
            return false;
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest);
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof TileEntityRopePost) {
            NonNullList drops = NonNullList.func_191196_a();
            drops.add((Object)((TileEntityRopePost)te).getPlanks());
            IBlockState fenceState = ((TileEntityRopePost)te).getFenceState();
            if (fenceState != null) {
                fenceState.func_177230_c().getDrops(drops, (IBlockAccess)worldIn, pos, fenceState, 0);
            }
            for (ItemStack drop : drops) {
                BlockRopePost.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)drop);
            }
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        drops.add((Object)new ItemStack(BWMBlocks.ROPE));
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (playerIn == null) {
            return false;
        }
        TileEntity te = worldIn.func_175625_s(pos);
        ItemStack stack = playerIn.func_184586_b(hand);
        if (te instanceof TileEntityRopePost && !playerIn.func_70093_af() && ItemUtil.matchesOreDict(stack, "plankWood")) {
            TileEntityRopePost tile = (TileEntityRopePost)te;
            if (worldIn.field_72995_K) {
                return true;
            }
            if (tile.getPlanks().func_190926_b()) {
                tile.setPlanks(stack.func_77979_a(1));
            }
            return true;
        }
        return super.func_180639_a(worldIn, pos, state, playerIn, hand, facing, hitX, hitY, hitZ);
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return state.func_177226_a((IProperty)field_176526_a, (Comparable)Boolean.valueOf(this.hasRope(worldIn, pos, EnumFacing.NORTH))).func_177226_a((IProperty)field_176527_M, (Comparable)Boolean.valueOf(this.hasRope(worldIn, pos, EnumFacing.SOUTH))).func_177226_a((IProperty)field_176525_b, (Comparable)Boolean.valueOf(this.hasRope(worldIn, pos, EnumFacing.EAST))).func_177226_a((IProperty)field_176528_N, (Comparable)Boolean.valueOf(this.hasRope(worldIn, pos, EnumFacing.WEST)));
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity te;
        TileEntity tileEntity = te = world instanceof ChunkCache ? ((ChunkCache)world).func_190300_a(pos, Chunk.EnumCreateEntityType.CHECK) : world.func_175625_s(pos);
        if (te instanceof TileEntityRopePost) {
            TileEntityRopePost tile = (TileEntityRopePost)te;
            IExtendedBlockState withplanks = ((IExtendedBlockState)state).withProperty(HELD_WORLD, (Object)world).withProperty(HELD_POS, (Object)pos).withProperty(HELD_STATE, (Object)tile.getFenceState()).withProperty(HELD_PLANKS, (Object)tile.getPlanks());
            return withplanks;
        }
        return state;
    }

    private boolean hasRope(IBlockAccess world, BlockPos pos, EnumFacing facing) {
        IBlockState state1 = world.func_180495_p(pos.func_177972_a(facing));
        return state1.func_177230_c() == ModBlocks.ROPE_SIDEWAYS && ((BlockRopeSideways.EnumRopeShape)((Object)state1.func_177229_b(BlockRopeSideways.SHAPE))).has(facing.func_176740_k());
    }

    public int func_176201_c(IBlockState state) {
        return ((Boolean)state.func_177229_b((IProperty)HAS_PLANKS) != false ? 1 : 0) | ((Boolean)state.func_177229_b((IProperty)HAS_POST) != false ? 2 : 0);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)HAS_PLANKS, (Comparable)Boolean.valueOf((meta & 1) > 0)).func_177226_a((IProperty)HAS_POST, (Comparable)Boolean.valueOf((meta & 2) > 0));
    }

    protected BlockStateContainer func_180661_e() {
        return new ExtendedBlockState((Block)this, new IProperty[]{field_176526_a, field_176527_M, field_176525_b, field_176528_N, HAS_PLANKS, HAS_POST}, new IUnlistedProperty[]{HELD_PLANKS, HELD_WORLD, HELD_POS, HELD_STATE});
    }

    public void placeFencePost(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        world.func_175656_a(pos, this.func_176223_P());
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityRopePost) {
            ((TileEntityRopePost)te).setFenceState(state);
        }
    }
}

