/*
 * Decompiled with CFR 0.152.
 */
package betterwithaddons.block;

import betterwithaddons.block.BlockBase;
import betterwithaddons.block.ColorHandlers;
import betterwithaddons.block.IColorable;
import betterwithaddons.util.IHasVariants;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.IGrowable;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;

public class BlockEcksieSapling
extends BlockBase
implements IGrowable,
IPlantable,
IHasVariants,
IColorable {
    public static PropertyInteger TYPE = PropertyInteger.func_177719_a((String)"type", (int)0, (int)15);
    public static PropertyBool INVENTORY = PropertyBool.func_177716_a((String)"inventory");

    protected BlockEcksieSapling(String name) {
        super(name, Material.field_151575_d);
        this.func_149675_a(true);
        this.func_149711_c(0.5f);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{TYPE, INVENTORY});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)TYPE, (Comparable)Integer.valueOf(meta)).func_177226_a((IProperty)INVENTORY, (Comparable)Boolean.valueOf(false));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)TYPE);
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        IBlockState soil = worldIn.func_180495_p(pos.func_177977_b());
        return super.func_176196_c(worldIn, pos) && soil.func_177230_c().canSustainPlant(soil, (IBlockAccess)worldIn, pos.func_177977_b(), EnumFacing.UP, (IPlantable)this);
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        super.func_189540_a(state, worldIn, pos, blockIn, fromPos);
        this.checkAndDropBlock(worldIn, pos, state);
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.func_180633_a(worldIn, pos, state, placer, stack);
        if (worldIn.func_175623_d(pos.func_177984_a())) {
            worldIn.func_175656_a(pos.func_177984_a(), this.getLeaf(state));
        }
    }

    protected void checkAndDropBlock(World worldIn, BlockPos pos, IBlockState state) {
        if (!this.canBlockStay(worldIn, pos, state)) {
            this.func_176226_b(worldIn, pos, state, 0);
            worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
        }
    }

    public boolean canBlockStay(World worldIn, BlockPos pos, IBlockState state) {
        IBlockState soil = worldIn.func_180495_p(pos.func_177977_b());
        return soil.func_177230_c().canSustainPlant(soil, (IBlockAccess)worldIn, pos.func_177977_b(), EnumFacing.UP, (IPlantable)this);
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (!worldIn.field_72995_K) {
            this.checkAndDropBlock(worldIn, pos, state);
            if (worldIn.func_175671_l(pos.func_177984_a()) >= 9) {
                this.func_176474_b(worldIn, rand, pos, state);
            }
        }
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_176473_a(World worldIn, BlockPos pos, IBlockState state, boolean isClient) {
        return true;
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        return false;
    }

    private IBlockState getLeaf(IBlockState state) {
        return this.getLeafBlock((Integer)state.func_177229_b((IProperty)TYPE));
    }

    public int getTypes() {
        return 0;
    }

    public IBlockState getLeafBlock(int type) {
        return Blocks.field_150350_a.func_176223_P();
    }

    public void func_176474_b(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        IBlockState leaf = this.getLeaf(state);
        block0: for (int attempts = worldIn.field_73012_v.nextInt(8) + 1; attempts > 0; --attempts) {
            BlockPos.MutableBlockPos seeker = new BlockPos.MutableBlockPos(pos.func_177984_a());
            for (int dist = 0; dist < 7; ++dist) {
                IBlockState seekstate = worldIn.func_180495_p((BlockPos)seeker);
                if (seekstate != leaf) {
                    if (!worldIn.func_175623_d((BlockPos)seeker) && !seekstate.func_177230_c().func_176200_f((IBlockAccess)worldIn, (BlockPos)seeker)) continue block0;
                    worldIn.func_175656_a((BlockPos)seeker, leaf);
                    if (dist >= 2) continue block0;
                    --attempts;
                    continue block0;
                }
                int xoff = worldIn.field_73012_v.nextInt(3) - 1;
                int zoff = xoff == 0 ? worldIn.field_73012_v.nextInt(2) * 2 - 1 : 0;
                seeker.func_181079_c(seeker.func_177958_n() + xoff, seeker.func_177956_o(), seeker.func_177952_p() + zoff);
            }
        }
    }

    public boolean canSustainLeaves(IBlockState state, IBlockAccess world, BlockPos pos) {
        return true;
    }

    public int func_149745_a(Random random) {
        return 0;
    }

    public EnumPlantType getPlantType(IBlockAccess world, BlockPos pos) {
        return EnumPlantType.Plains;
    }

    public IBlockState getPlant(IBlockAccess world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() != this) {
            return this.func_176223_P();
        }
        return state;
    }

    @Override
    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (!this.disabled) {
            for (int i = 0; i < 16; ++i) {
                if (i >= this.getTypes() || this.getLeafBlock(i) == null) continue;
                items.add((Object)new ItemStack((Block)this, 1, i));
            }
        }
    }

    @Override
    public List<ModelResourceLocation> getVariantModels() {
        ArrayList<ModelResourceLocation> rlist = new ArrayList<ModelResourceLocation>();
        for (int i = 0; i < 16; ++i) {
            if (i >= this.getTypes() || this.getLeafBlock(i) == null) continue;
            rlist.add(new ModelResourceLocation(this.getRegistryName(), "inventory=true,type=" + i));
        }
        return rlist;
    }

    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    @Override
    public String getVariantName(int meta) {
        return null;
    }

    @Override
    public IBlockColor getBlockColor() {
        return null;
    }

    @Override
    public IItemColor getItemColor() {
        return ColorHandlers.ECKSIE_COLORING;
    }
}

