/*
 * Decompiled with CFR 0.152.
 */
package betterwithaddons.block;

import betterwithaddons.BetterWithAddons;
import betterwithaddons.block.BlockAqueduct;
import betterwithaddons.block.IColorable;
import betterwithaddons.interaction.InteractionBWA;
import betterwithaddons.tileentity.TileEntityAqueductWater;
import java.util.HashSet;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeColorHelper;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fluids.BlockFluidClassic;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockAqueductWater
extends BlockFluidClassic
implements IColorable {
    protected BlockAqueductWater() {
        super(FluidRegistry.WATER, Material.field_151586_h);
        String name = "aqueduct_water";
        this.func_149663_c(name);
        this.setRegistryName(new ResourceLocation("betterwithaddons", name));
        this.func_149647_a(BetterWithAddons.instance.creativeTab);
        this.func_149675_a(true);
        this.func_180632_j(this.func_176223_P().func_177226_a((IProperty)LEVEL, (Comparable)Integer.valueOf(0)));
        this.stack.amount = InteractionBWA.AQUEDUCT_WATER_AMOUNT;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEntityAqueductWater();
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos) {
        world.func_175684_a(pos, (Block)this, this.func_149738_a(world));
    }

    public boolean checkAndDry(World world, BlockPos pos, IBlockState state) {
        IBlockState bottomstate = world.func_180495_p(pos.func_177977_b());
        if (world.func_175623_d(pos.func_177977_b()) || !(bottomstate.func_177230_c() instanceof BlockAqueduct)) {
            this.dry(world, pos);
            return false;
        }
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityAqueductWater) {
            int currdist = ((TileEntityAqueductWater)te).getDistanceFromSource();
            int dist = TileEntityAqueductWater.getMinDistance(world, pos) + 1;
            if (dist > currdist || dist > InteractionBWA.AQUEDUCT_MAX_LENGTH) {
                this.dry(world, pos);
                return false;
            }
            ((TileEntityAqueductWater)te).setDistanceFromSource(dist);
            if (dist != currdist) {
                world.func_175656_a(pos, state);
            }
        } else {
            this.dry(world, pos);
            return false;
        }
        return true;
    }

    public void dry(World world, BlockPos pos) {
        world.func_175656_a(pos, Blocks.field_150358_i.func_176223_P().func_177226_a((IProperty)LEVEL, (Comparable)Integer.valueOf(8)));
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        boolean keep = this.checkAndDry(world, pos, state);
        if (!keep) {
            return;
        }
        int quantaRemaining = this.quantaPerBlock - (Integer)state.func_177229_b((IProperty)LEVEL) % 8;
        if (this.canDisplace((IBlockAccess)world, pos.func_177981_b(this.densityDir))) {
            this.flowIntoBlock(world, pos.func_177981_b(this.densityDir), 1);
            return;
        }
        int flowMeta = this.quantaPerBlock - quantaRemaining + 1;
        if (flowMeta >= this.quantaPerBlock) {
            return;
        }
        if (this.isSourceBlock((IBlockAccess)world, pos) || !this.isFlowingVertically((IBlockAccess)world, pos)) {
            boolean[] flowTo;
            if (world.func_180495_p(pos.func_177979_c(this.densityDir)).func_177230_c() == this) {
                flowMeta = 1;
            }
            if ((flowTo = this.getOptimalFlowDirections(world, pos))[0]) {
                this.flowIntoBlock(world, pos.func_177982_a(-1, 0, 0), flowMeta);
            }
            if (flowTo[1]) {
                this.flowIntoBlock(world, pos.func_177982_a(1, 0, 0), flowMeta);
            }
            if (flowTo[2]) {
                this.flowIntoBlock(world, pos.func_177982_a(0, 0, -1), flowMeta);
            }
            if (flowTo[3]) {
                this.flowIntoBlock(world, pos.func_177982_a(0, 0, 1), flowMeta);
            }
        }
        world.func_175684_a(pos, (Block)this, this.func_149738_a(world));
    }

    protected void flowIntoBlock(World world, BlockPos pos, int meta) {
        if (meta < 0) {
            return;
        }
        if (this.displaceIfPossible(world, pos) && world.func_180495_p(pos).func_185904_a() != Material.field_151586_h) {
            world.func_180501_a(pos, Blocks.field_150358_i.func_176223_P().func_177226_a((IProperty)LEVEL, (Comparable)Integer.valueOf(meta)), 3);
        }
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        worldIn.func_175684_a(pos, (Block)this, this.func_149738_a(worldIn));
    }

    private int getDepth(IBlockAccess world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        int level = 0;
        if (state.func_185904_a() != Material.field_151586_h) {
            level = -1;
        } else if (state.func_177230_c() == this) {
            TileEntity te = world.func_175625_s(pos);
            if (te instanceof TileEntityAqueductWater) {
                return ((TileEntityAqueductWater)te).getDistanceFromSource();
            }
        } else if ((Integer)state.func_177229_b((IProperty)LEVEL) != 0) {
            level = (Integer)state.func_177229_b((IProperty)LEVEL) + InteractionBWA.AQUEDUCT_MAX_LENGTH;
        }
        return level;
    }

    public Vec3d getFlowVector(IBlockAccess world, BlockPos pos) {
        int l;
        int otherlevel;
        double flowx = 0.0;
        double flowy = 0.0;
        double flowz = 0.0;
        int thislevel = this.getDepth(world, pos);
        BlockPos.PooledMutableBlockPos checkpos = BlockPos.PooledMutableBlockPos.func_185346_s();
        EnumFacing flowDir = EnumFacing.DOWN;
        HashSet<BlockPos> corners = new HashSet<BlockPos>();
        for (EnumFacing enumfacing : EnumFacing.field_176754_o) {
            checkpos.func_189533_g((Vec3i)pos).func_189536_c(enumfacing);
            otherlevel = this.getDepth(world, (BlockPos)checkpos);
            if (otherlevel < 0) continue;
            l = otherlevel - thislevel;
            flowx += (double)(enumfacing.func_82601_c() * l);
            flowy += (double)(enumfacing.func_96559_d() * l);
            flowz += (double)(enumfacing.func_82599_e() * l);
            corners.add(checkpos.func_177967_a(enumfacing.func_176746_e(), 1));
            corners.add(checkpos.func_177967_a(enumfacing.func_176746_e(), -1));
        }
        for (BlockPos cornerpos : corners) {
            int xdiff = cornerpos.func_177958_n() - pos.func_177958_n();
            int zdiff = cornerpos.func_177952_p() - pos.func_177952_p();
            otherlevel = this.getDepth(world, cornerpos);
            if (otherlevel < 0) continue;
            l = otherlevel - thislevel;
            flowx += (double)(xdiff * l);
            flowz += (double)(zdiff * l);
        }
        flowDir = EnumFacing.func_176737_a((float)((float)flowx), (float)((float)flowy), (float)((float)flowz));
        if (flowDir.func_176740_k().func_176722_c()) {
            EnumFacing right = flowDir.func_176746_e();
            EnumFacing left = flowDir.func_176735_f();
            boolean rightDone = false;
            boolean leftDone = false;
            int leftDist = 0;
            int rightDist = 0;
            for (int i = 1; i < 8; ++i) {
                if (!rightDone) {
                    int rightDepth = this.getDepth(world, pos.func_177967_a(right, i));
                    if (rightDepth > thislevel) {
                        rightDist = 7;
                    }
                    boolean bl = rightDone = rightDepth == -1 || rightDepth > thislevel;
                }
                if (leftDone) continue;
                int leftDepth = this.getDepth(world, pos.func_177967_a(left, i));
                if (leftDepth > thislevel) {
                    leftDist = 8 - i;
                }
                leftDone = leftDepth == -1 || leftDepth > thislevel;
            }
            flowx += (double)(left.func_82601_c() * leftDist + right.func_82601_c() * rightDist);
            flowz += (double)(left.func_82599_e() * leftDist + right.func_82599_e() * rightDist);
        }
        Vec3d vec3d = new Vec3d(flowx, flowy, flowz);
        checkpos.func_185344_t();
        return vec3d.func_72432_b();
    }

    public boolean func_176209_a(@Nonnull IBlockState state, boolean fullHit) {
        return fullHit;
    }

    public boolean canSustainPlant(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing direction, IPlantable plantable) {
        return direction == EnumFacing.UP && plantable.getPlantType(world, pos.func_177984_a()) == EnumPlantType.Water;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)LEVEL, (Comparable)Integer.valueOf(8));
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    public int place(World world, BlockPos pos, @Nonnull FluidStack fluidStack, boolean doPlace) {
        return 0;
    }

    @Nullable
    public FluidStack drain(World world, BlockPos pos, boolean doDrain) {
        return this.stack.copy();
    }

    public boolean canDrain(World world, BlockPos pos) {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IBlockColor getBlockColor() {
        return (state, worldIn, pos, tintIndex) -> worldIn != null && pos != null ? BiomeColorHelper.func_180288_c((IBlockAccess)worldIn, (BlockPos)pos) : -1;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IItemColor getItemColor() {
        return null;
    }
}

