/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.tools;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NBTTagString;

public class NBTTool {
    public static NBTTagByteArray createBooleanList(boolean[] booleans) {
        byte[] bytes = new byte[booleans.length];
        for (int i = 0; i < booleans.length; ++i) {
            bytes[i] = (byte)(!booleans[i] ? 1 : 0);
        }
        return new NBTTagByteArray(bytes);
    }

    public static NBTTagByteArray createBooleanList(Boolean[] booleans) {
        byte[] bytes = new byte[booleans.length];
        for (int i = 0; i < booleans.length; ++i) {
            bytes[i] = (byte)(booleans[i] == false ? 1 : 0);
        }
        return new NBTTagByteArray(bytes);
    }

    public static NBTTagList createShortList(short[] shorts) {
        NBTTagList list = new NBTTagList();
        for (short s : shorts) {
            list.func_74742_a((NBTBase)new NBTTagShort(s));
        }
        return list;
    }

    public static NBTTagList createShortList(Short[] shorts) {
        NBTTagList list = new NBTTagList();
        Short[] shortArray = shorts;
        int n = shortArray.length;
        for (int i = 0; i < n; ++i) {
            short s = shortArray[i];
            list.func_74742_a((NBTBase)new NBTTagShort(s));
        }
        return list;
    }

    @Nonnull
    public static NBTTagList createFloatList(float[] floats) {
        NBTTagList list = new NBTTagList();
        for (float f : floats) {
            list.func_74742_a((NBTBase)new NBTTagFloat(f));
        }
        return list;
    }

    @Nonnull
    public static NBTTagList createFloatList(Float[] floats) {
        NBTTagList list = new NBTTagList();
        for (Float f : floats) {
            list.func_74742_a((NBTBase)new NBTTagFloat(f.floatValue()));
        }
        return list;
    }

    @Nonnull
    public static NBTTagList createDoubleList(double[] doubles) {
        NBTTagList list = new NBTTagList();
        for (double d : doubles) {
            list.func_74742_a((NBTBase)new NBTTagDouble(d));
        }
        return list;
    }

    @Nonnull
    public static NBTTagList createDoubleList(Double[] doubles) {
        NBTTagList list = new NBTTagList();
        for (Double d : doubles) {
            list.func_74742_a((NBTBase)new NBTTagDouble(d.doubleValue()));
        }
        return list;
    }

    @Nonnull
    public static short[] readShortList(NBTTagList shorts) {
        short[] res = new short[shorts.func_74745_c()];
        IntArrayList failed = new IntArrayList();
        for (int i = 0; i < shorts.func_74745_c(); ++i) {
            NBTBase nbt = shorts.func_179238_g(i);
            if (nbt instanceof NBTTagShort) {
                res[i] = ((NBTTagShort)nbt).func_150289_e();
                continue;
            }
            res[i] = 0;
            failed.add(i);
        }
        if (!failed.isEmpty()) {
            short[] shortened = new short[res.length - failed.size()];
            int shortenedCount = 0;
            for (int i = 0; i < res.length; ++i) {
                if (failed.contains(i)) continue;
                shortened[shortenedCount] = res[i];
                ++shortenedCount;
            }
            res = shortened;
        }
        return res;
    }

    @Nonnull
    public static Short[] readBShortList(NBTTagList shorts) {
        Short[] res = new Short[shorts.func_74745_c()];
        IntArrayList failed = new IntArrayList();
        for (int i = 0; i < shorts.func_74745_c(); ++i) {
            NBTBase nbt = shorts.func_179238_g(i);
            if (nbt instanceof NBTTagShort) {
                res[i] = ((NBTTagShort)nbt).func_150289_e();
                continue;
            }
            res[i] = 0;
            failed.add(i);
        }
        if (!failed.isEmpty()) {
            Short[] shortened = new Short[res.length - failed.size()];
            int shortenedCount = 0;
            for (int i = 0; i < res.length; ++i) {
                if (failed.contains(i)) continue;
                shortened[shortenedCount] = res[i];
                ++shortenedCount;
            }
            res = shortened;
        }
        return res;
    }

    @Nonnull
    public static NBTTagList createStringList(String[] strings) {
        NBTTagList list = new NBTTagList();
        for (String s : strings) {
            list.func_74742_a((NBTBase)new NBTTagString(s));
        }
        return list;
    }

    @Nonnull
    public static float[] readFloatList(NBTTagList floats) {
        float[] res = new float[floats.func_74745_c()];
        IntArrayList failed = new IntArrayList();
        for (int i = 0; i < floats.func_74745_c(); ++i) {
            NBTBase nbt = floats.func_179238_g(i);
            if (nbt instanceof NBTTagFloat) {
                res[i] = ((NBTTagFloat)nbt).func_150288_h();
                continue;
            }
            res[i] = 0.0f;
            failed.add(i);
        }
        if (!failed.isEmpty()) {
            float[] shortened = new float[res.length - failed.size()];
            int shortenedCount = 0;
            for (int i = 0; i < res.length; ++i) {
                if (failed.contains(i)) continue;
                shortened[shortenedCount] = res[i];
                ++shortenedCount;
            }
            res = shortened;
        }
        return res;
    }

    @Nonnull
    public static Float[] readBFloatList(NBTTagList floats) {
        Float[] res = new Float[floats.func_74745_c()];
        IntArrayList failed = new IntArrayList();
        for (int i = 0; i < floats.func_74745_c(); ++i) {
            NBTBase nbt = floats.func_179238_g(i);
            if (nbt instanceof NBTTagFloat) {
                res[i] = Float.valueOf(((NBTTagFloat)nbt).func_150288_h());
                continue;
            }
            res[i] = Float.valueOf(0.0f);
            failed.add(i);
        }
        if (!failed.isEmpty()) {
            Float[] shortened = new Float[res.length - failed.size()];
            int shortenedCount = 0;
            for (int i = 0; i < res.length; ++i) {
                if (failed.contains(i)) continue;
                shortened[shortenedCount] = res[i];
                ++shortenedCount;
            }
            res = shortened;
        }
        return res;
    }

    @Nonnull
    public static double[] readDoubleList(NBTTagList doubles) {
        double[] res = new double[doubles.func_74745_c()];
        IntArrayList failed = new IntArrayList();
        for (int i = 0; i < doubles.func_74745_c(); ++i) {
            NBTBase nbt = doubles.func_179238_g(i);
            if (nbt instanceof NBTTagDouble) {
                res[i] = ((NBTTagDouble)nbt).func_150286_g();
                continue;
            }
            res[i] = 0.0;
            failed.add(i);
        }
        if (!failed.isEmpty()) {
            double[] shortened = new double[res.length - failed.size()];
            int shortenedCount = 0;
            for (int i = 0; i < res.length; ++i) {
                if (failed.contains(i)) continue;
                shortened[shortenedCount] = res[i];
                ++shortenedCount;
            }
            res = shortened;
        }
        return res;
    }

    @Nonnull
    public static Double[] readBDoubleList(NBTTagList doubles) {
        Double[] res = new Double[doubles.func_74745_c()];
        IntArrayList failed = new IntArrayList();
        for (int i = 0; i < doubles.func_74745_c(); ++i) {
            NBTBase nbt = doubles.func_179238_g(i);
            if (nbt instanceof NBTTagDouble) {
                res[i] = ((NBTTagDouble)nbt).func_150286_g();
                continue;
            }
            res[i] = 0.0;
            failed.add(i);
        }
        if (!failed.isEmpty()) {
            Double[] shortened = new Double[res.length - failed.size()];
            int shortenedCount = 0;
            for (int i = 0; i < res.length; ++i) {
                if (failed.contains(i)) continue;
                shortened[shortenedCount] = res[i];
                ++shortenedCount;
            }
            res = shortened;
        }
        return res;
    }

    @Nonnull
    public static String[] readStringList(NBTTagList strings) {
        String[] res = new String[strings.func_74745_c()];
        IntArrayList failed = new IntArrayList();
        for (int i = 0; i < strings.func_74745_c(); ++i) {
            NBTBase nbt = strings.func_179238_g(i);
            if (nbt instanceof NBTTagString) {
                res[i] = ((NBTTagString)nbt).func_150285_a_();
                continue;
            }
            res[i] = "";
            failed.add(i);
        }
        if (!failed.isEmpty()) {
            String[] shortened = new String[res.length - failed.size()];
            int shortenedCount = 0;
            for (int i = 0; i < res.length; ++i) {
                if (failed.contains(i)) continue;
                shortened[shortenedCount] = res[i];
                ++shortenedCount;
            }
            res = shortened;
        }
        return res;
    }

    public static boolean[] readBooleanList(NBTTagByteArray booleans) {
        byte[] bytes = booleans.func_150292_c();
        boolean[] res = new boolean[bytes.length];
        for (int i = 0; i < bytes.length; ++i) {
            res[i] = bytes[i] == 0;
        }
        return res;
    }

    public static Boolean[] readBBooleanList(NBTTagByteArray booleans) {
        byte[] bytes = booleans.func_150292_c();
        Boolean[] res = new Boolean[bytes.length];
        for (int i = 0; i < bytes.length; ++i) {
            res[i] = bytes[i] == 0;
        }
        return res;
    }

    public static <K, V> NBTTagList serializeMap(Map<K, V> map, Function<K, NBTBase> keySerializer, Function<V, NBTBase> valueSerializer) {
        NBTTagList list = new NBTTagList();
        for (Map.Entry<K, V> entry : map.entrySet()) {
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74782_a("key", keySerializer.apply(entry.getKey()));
            compound.func_74782_a("val", valueSerializer.apply(entry.getValue()));
            list.func_74742_a((NBTBase)compound);
        }
        return list;
    }

    public static <K, V> Map<K, V> deserializeMap(NBTTagList list, Map<K, V> toAppendTo, Function<NBTBase, K> keyDeserializer, Function<NBTBase, V> valueDeserializer) {
        for (NBTBase nbt : list) {
            if (!(nbt instanceof NBTTagCompound)) continue;
            NBTTagCompound compound = (NBTTagCompound)nbt;
            toAppendTo.put(keyDeserializer.apply(compound.func_74781_a("key")), valueDeserializer.apply(compound.func_74781_a("val")));
        }
        return toAppendTo;
    }

    public static NBTTagCompound getOrNewTag(ItemStack stack) {
        if (stack.func_77942_o()) {
            return stack.func_77978_p();
        }
        NBTTagCompound tag = new NBTTagCompound();
        stack.func_77982_d(tag);
        return tag;
    }
}

