/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.items.capability;

import com.google.common.collect.ImmutableList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class MultiCapabilityProvider
implements ICapabilityProvider {
    private final ImmutableList<ICapabilityProvider> childProviders;

    public MultiCapabilityProvider(ICapabilityProvider ... childProviders) {
        this((ImmutableList<ICapabilityProvider>)ImmutableList.copyOf((Object[])childProviders));
    }

    public MultiCapabilityProvider(ImmutableList<ICapabilityProvider> childProviders) {
        this.childProviders = childProviders;
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        for (ICapabilityProvider childProvider : this.childProviders) {
            if (!childProvider.hasCapability(capability, facing)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        for (ICapabilityProvider childProvider : this.childProviders) {
            Object handle = childProvider.getCapability(capability, facing);
            if (handle == null) continue;
            return (T)handle;
        }
        return null;
    }
}

