/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.client;

import com.direwolf20.buildinggadgets.common.network.PacketHandler;
import com.direwolf20.buildinggadgets.common.network.PacketSetRemoteInventoryCache;
import com.direwolf20.buildinggadgets.common.tools.GadgetUtils;
import com.direwolf20.buildinggadgets.common.tools.InventoryManipulation;
import com.direwolf20.buildinggadgets.common.tools.UniqueItem;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Multiset;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

@SideOnly(value=Side.CLIENT)
public class RemoteInventoryCache
implements InventoryManipulation.IRemoteInventoryProvider {
    private boolean isCopyPaste;
    private boolean forceUpdate;
    private Pair<Integer, BlockPos> locCached;
    private Multiset<UniqueItem> cache;
    private Stopwatch timer;

    public RemoteInventoryCache(boolean isCopyPaste) {
        this.isCopyPaste = isCopyPaste;
    }

    public void setCache(Multiset<UniqueItem> cache) {
        this.cache = cache;
    }

    public void forceUpdate() {
        this.forceUpdate = true;
    }

    @Override
    public int countItem(ItemStack tool, ItemStack stack) {
        Pair<Integer, BlockPos> loc = this.getInventoryLocation(tool);
        if (this.isCacheOld(loc)) {
            this.updateCache(loc);
        }
        return this.cache == null ? 0 : this.cache.count((Object)new UniqueItem(stack.func_77973_b(), stack.func_77960_j()));
    }

    private void updateCache(Pair<Integer, BlockPos> loc) {
        this.locCached = loc;
        if (loc == null) {
            this.cache = null;
        } else {
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketSetRemoteInventoryCache(loc, this.isCopyPaste));
        }
    }

    private boolean isCacheOld(@Nullable Pair<Integer, BlockPos> loc) {
        if (this.locCached == null ? loc != null : !this.locCached.equals(loc)) {
            this.timer = loc == null ? null : Stopwatch.createStarted();
            return true;
        }
        if (this.timer != null) {
            boolean overtime;
            boolean bl = overtime = this.forceUpdate || this.timer.elapsed(TimeUnit.MILLISECONDS) >= 5000L;
            if (overtime) {
                this.timer.reset();
                this.timer.start();
                this.forceUpdate = false;
            }
            return overtime;
        }
        return false;
    }

    @Nullable
    private Pair<Integer, BlockPos> getInventoryLocation(ItemStack stack) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt == null) {
            return null;
        }
        Integer dim = GadgetUtils.getDIMFromNBT(stack, "boundTE");
        BlockPos pos = GadgetUtils.getPOSFromNBT(stack, "boundTE");
        return dim == null || pos == null ? null : new ImmutablePair((Object)dim, (Object)pos);
    }
}

