/*
 * Decompiled with CFR 0.152.
 */
package com.teamacronymcoders.contenttweaker.modules.vanilla.items.food;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.teamacronymcoders.base.IBaseMod;
import com.teamacronymcoders.base.client.models.IHasModel;
import com.teamacronymcoders.base.client.models.generator.IHasGeneratedModel;
import com.teamacronymcoders.base.client.models.generator.generatedmodel.GeneratedModel;
import com.teamacronymcoders.base.client.models.generator.generatedmodel.IGeneratedModel;
import com.teamacronymcoders.base.client.models.generator.generatedmodel.ModelType;
import com.teamacronymcoders.base.items.IHasItemColor;
import com.teamacronymcoders.base.util.files.templates.TemplateFile;
import com.teamacronymcoders.base.util.files.templates.TemplateManager;
import com.teamacronymcoders.contenttweaker.api.MissingFieldsException;
import com.teamacronymcoders.contenttweaker.api.ctobjects.blockpos.MCBlockPos;
import com.teamacronymcoders.contenttweaker.api.ctobjects.blockstate.MCBlockState;
import com.teamacronymcoders.contenttweaker.api.ctobjects.entity.EntityHelper;
import com.teamacronymcoders.contenttweaker.api.ctobjects.entity.player.CTPlayer;
import com.teamacronymcoders.contenttweaker.api.ctobjects.enums.Facing;
import com.teamacronymcoders.contenttweaker.api.ctobjects.enums.Hand;
import com.teamacronymcoders.contenttweaker.api.ctobjects.mutableitemstack.MCMutableItemStack;
import com.teamacronymcoders.contenttweaker.api.ctobjects.resourcelocation.CTResourceLocation;
import com.teamacronymcoders.contenttweaker.api.ctobjects.world.MCWorld;
import com.teamacronymcoders.contenttweaker.api.utils.CTUtils;
import com.teamacronymcoders.contenttweaker.modules.vanilla.functions.IItemFoodEaten;
import com.teamacronymcoders.contenttweaker.modules.vanilla.items.food.ItemFoodRepresentation;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import crafttweaker.api.util.Position3f;
import crafttweaker.mc1120.item.MCItemStack;
import crafttweaker.mc1120.util.MCPosition3f;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemContentFood
extends ItemFood
implements IHasModel,
IHasGeneratedModel,
IHasItemColor {
    private final ItemFoodRepresentation itemRepresentation;
    private CreativeTabs creativeTab;
    private IBaseMod mod;
    private EnumAction itemUseAction;
    private EnumRarity rarity;

    public ItemContentFood(ItemFoodRepresentation itemRepresentation) {
        super(itemRepresentation.getHealAmount(), itemRepresentation.getSaturation(), itemRepresentation.isWolfFood());
        this.itemRepresentation = itemRepresentation;
        this.checkFields();
        this.setFields();
    }

    public IBaseMod getMod() {
        return this.mod;
    }

    public void setMod(IBaseMod mod) {
        this.mod = mod;
    }

    public void checkFields() {
        ArrayList<String> missingFields = new ArrayList<String>();
        if (this.itemRepresentation.getUnlocalizedName() == null) {
            missingFields.add("unlocalizedName");
        }
        if (!missingFields.isEmpty()) {
            throw new MissingFieldsException("ItemFoodRepresentation", missingFields);
        }
    }

    public void setFields() {
        Object creativeTab;
        this.func_77655_b(this.itemRepresentation.getUnlocalizedName());
        if (this.itemRepresentation.getCreativeTab() != null && (creativeTab = this.itemRepresentation.getCreativeTab().getInternal()) instanceof CreativeTabs) {
            this.func_77637_a((CreativeTabs)this.itemRepresentation.getCreativeTab().getInternal());
        }
        this.func_77625_d(this.itemRepresentation.getMaxStackSize());
        this.setHarvestLevel(this.itemRepresentation.getToolClass(), this.itemRepresentation.getToolLevel());
        this.itemUseAction = CTUtils.getEnum(this.itemRepresentation.getItemUseAction(), EnumAction.class);
        this.rarity = CTUtils.getEnum(this.itemRepresentation.getRarity(), EnumRarity.class);
        if (this.itemRepresentation.getMaxDamage() > 0) {
            this.func_77656_e(this.itemRepresentation.getMaxDamage());
        }
        if (this.itemRepresentation.alwaysEdible) {
            this.func_77848_i();
        }
    }

    @Nonnull
    public EnumRarity func_77613_e(@Nonnull ItemStack itemStack) {
        return this.rarity;
    }

    public float getSmeltingExperience(@Nonnull ItemStack itemStack) {
        return this.itemRepresentation.getSmeltingExperience();
    }

    public boolean isBeaconPayment(@Nonnull ItemStack itemStack) {
        return this.itemRepresentation.isBeaconPayment();
    }

    @SideOnly(value=Side.CLIENT)
    public CreativeTabs func_77640_w() {
        return this.creativeTab;
    }

    @Nonnull
    public Item func_77637_a(@Nonnull CreativeTabs creativeTab) {
        this.creativeTab = creativeTab;
        return this;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return this.itemRepresentation.isGlowing() || super.func_77636_d(stack);
    }

    @Nonnull
    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        EnumActionResult actionResult = EnumActionResult.PASS;
        if (Objects.nonNull(this.itemRepresentation.getOnItemUse())) {
            MCPosition3f blockTouch = new MCPosition3f(hitX, hitY, hitZ);
            actionResult = this.itemRepresentation.getOnItemUse().useItem(new CTPlayer(player), new MCWorld(world), new MCBlockPos(pos), Hand.of(hand), Facing.of(facing), (Position3f)blockTouch).getInternal();
        }
        return actionResult;
    }

    public float func_150893_a(ItemStack stack, IBlockState state) {
        return Optional.ofNullable(this.itemRepresentation.getItemDestroySpeed()).map(value -> Float.valueOf(value.getDestroySpeed(new MCMutableItemStack(stack), new MCBlockState(state)))).orElseGet(() -> Float.valueOf(super.func_150893_a(stack, state))).floatValue();
    }

    public boolean func_179218_a(ItemStack stack, World world, IBlockState state, BlockPos pos, EntityLivingBase entityLiving) {
        return Optional.ofNullable(this.itemRepresentation.getItemDestroyedBlock()).map(value -> value.onBlockDestroyed(new MCMutableItemStack(stack), new MCWorld(world), new MCBlockState(state), new MCBlockPos(pos), EntityHelper.getIEntityLivingBase(entityLiving))).orElseGet(() -> super.func_179218_a(stack, world, state, pos, entityLiving));
    }

    @Nonnull
    public EnumAction func_77661_b(@Nonnull ItemStack stack) {
        return this.itemUseAction;
    }

    public List<String> getModelNames(List<String> modelNames) {
        modelNames.add(this.func_77658_a().substring(5));
        return modelNames;
    }

    public List<ItemStack> getAllSubItems(List<ItemStack> itemStacks) {
        itemStacks.add(new ItemStack((Item)this));
        return itemStacks;
    }

    public Item getItem() {
        return this;
    }

    public List<IGeneratedModel> getGeneratedModels() {
        ArrayList models = Lists.newArrayList();
        TemplateFile templateFile = TemplateManager.getTemplateFile((String)"item_model");
        HashMap replacements = Maps.newHashMap();
        replacements.put("texture", Optional.ofNullable(this.itemRepresentation.getTextureLocation()).map(CTResourceLocation::getInternal).map(ResourceLocation::toString).orElseGet(() -> "contenttweaker:items/" + this.itemRepresentation.getUnlocalizedName()));
        templateFile.replaceContents((Map)replacements);
        models.add(new GeneratedModel(this.itemRepresentation.getUnlocalizedName(), ModelType.ITEM_MODEL, templateFile.getFileContents()));
        return models;
    }

    public boolean hasContainerItem(ItemStack itemStack) {
        return this.itemRepresentation.getItemGetContainerItem() != null || super.hasContainerItem(itemStack);
    }

    @Nonnull
    public ItemStack getContainerItem(@Nonnull ItemStack itemStack) {
        return Optional.ofNullable(this.itemRepresentation.getItemGetContainerItem()).map(getContainerItem -> getContainerItem.getContainerItem((IItemStack)new MCItemStack(itemStack))).map(result -> (ItemStack)result.getInternal()).orElseGet(() -> super.getContainerItem(itemStack));
    }

    public int getColorFromItemstack(@Nonnull ItemStack stack, int tintIndex) {
        return this.itemRepresentation.getItemColorSupplier().getColor((IItemStack)new MCItemStack(stack), tintIndex).getIntColor();
    }

    @Nonnull
    public String func_77653_i(@Nonnull ItemStack stack) {
        return Optional.ofNullable(this.itemRepresentation.getLocalizedNameSupplier()).map(supplier -> supplier.getLocalizedName((IItemStack)new MCItemStack(stack))).orElseGet(() -> super.func_77653_i(stack));
    }

    protected void func_77849_c(ItemStack stack, World worldIn, @Nonnull EntityPlayer player) {
        IItemFoodEaten onItemFoodEaten = this.itemRepresentation.getOnItemFoodEaten();
        if (onItemFoodEaten != null) {
            onItemFoodEaten.handle(new MCMutableItemStack(stack), new MCWorld(worldIn), new CTPlayer(player));
        } else {
            super.func_77849_c(stack, worldIn, player);
        }
    }

    public ItemStack func_77654_b(ItemStack stack, World worldIn, EntityLivingBase entityLiving) {
        return Optional.ofNullable(this.itemRepresentation.getOnItemUseFinish()).map(iItemUseFinish -> iItemUseFinish.getResult(new MCMutableItemStack(stack), new MCWorld(worldIn), EntityHelper.getIEntityLivingBase(entityLiving))).map(CraftTweakerMC::getItemStack).orElseGet(() -> super.func_77654_b(stack, worldIn, entityLiving));
    }
}

