/*
 * Decompiled with CFR 0.152.
 */
package com.teamacronymcoders.contenttweaker.modules.vanilla.enchantments;

import com.teamacronymcoders.contenttweaker.modules.vanilla.enchantments.EnchantmentFunctions;
import crafttweaker.api.enchantments.IEnchantmentDefinition;
import crafttweaker.api.entity.IEntityEquipmentSlot;
import crafttweaker.api.minecraft.CraftTweakerMC;
import crafttweaker.mc1120.enchantments.MCEnchantmentDefinition;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;

public class CoTEnchantment
extends Enchantment {
    public int minLevel = 0;
    public int maxLevel = 0;
    public boolean curse = false;
    public boolean treasure = false;
    public boolean allowedOnBooks = true;
    public EnchantmentFunctions.CalcCanApply apply = null;
    public EnchantmentFunctions.CalcCanApply applyAtEnchTable = null;
    public EnchantmentFunctions.CalcCanApplyTogether canApplyTogether = null;
    public EnchantmentFunctions.CalcDamageByCreature damageByCreature = null;
    public EnchantmentFunctions.CalcEnchantability enchantabilityMin = null;
    public EnchantmentFunctions.CalcEnchantability enchantabilityMax = null;
    public EnchantmentFunctions.CalcModifierDamage modifierDamage = null;
    public EnchantmentFunctions.CalcTranslatedName translatedName = null;
    public EnchantmentFunctions.OnEntityDamaged onEntityDamaged = null;
    public EnchantmentFunctions.OnUserHurt onUserHurt = null;
    public final IEnchantmentDefinition thisDefinition = new MCEnchantmentDefinition((Enchantment)this);

    private static EntityEquipmentSlot[] calcSlotArray(IEntityEquipmentSlot[] array) {
        EntityEquipmentSlot[] out = new EntityEquipmentSlot[array.length];
        for (int indec = 0; indec < array.length; ++indec) {
            out[indec] = CraftTweakerMC.getEntityEquipmentSlot((IEntityEquipmentSlot)array[indec]);
        }
        return out;
    }

    protected CoTEnchantment(Enchantment.Rarity rarity, EnumEnchantmentType type, IEntityEquipmentSlot[] applicableEquipmentTypes) {
        super(rarity, type, CoTEnchantment.calcSlotArray(applicableEquipmentTypes));
    }

    public int func_77319_d() {
        return this.minLevel;
    }

    public int func_77325_b() {
        return this.maxLevel;
    }

    public int func_77321_a(int enchantmentLevel) {
        if (this.enchantabilityMin != null) {
            return this.enchantabilityMin.handle(this.thisDefinition, enchantmentLevel);
        }
        return super.func_77317_b(enchantmentLevel);
    }

    public int func_77317_b(int enchantmentLevel) {
        if (this.enchantabilityMax != null) {
            return this.enchantabilityMax.handle(this.thisDefinition, enchantmentLevel);
        }
        return super.func_77317_b(enchantmentLevel);
    }

    public int func_77318_a(int level, DamageSource source) {
        if (this.modifierDamage != null) {
            return this.modifierDamage.handle(this.thisDefinition, level, CraftTweakerMC.getIDamageSource((DamageSource)source));
        }
        return super.func_77318_a(level, source);
    }

    public float func_152376_a(int level, EnumCreatureAttribute creatureType) {
        if (this.damageByCreature != null) {
            return this.damageByCreature.handle(this.thisDefinition, level, creatureType.name());
        }
        return super.func_152376_a(level, creatureType);
    }

    public String func_77316_c(int level) {
        if (this.translatedName != null) {
            return this.translatedName.handle(this.thisDefinition, level);
        }
        return super.func_77316_c(level);
    }

    public boolean func_92089_a(ItemStack stack) {
        if (this.apply != null) {
            return this.apply.handle(this.thisDefinition, CraftTweakerMC.getIItemStack((ItemStack)stack));
        }
        return super.canApplyAtEnchantingTable(stack);
    }

    public void func_151368_a(EntityLivingBase user, Entity target, int level) {
        if (this.onEntityDamaged != null) {
            this.onEntityDamaged.handle(this.thisDefinition, CraftTweakerMC.getIEntityLivingBase((EntityLivingBase)user), CraftTweakerMC.getIEntity((Entity)target), level);
        } else {
            super.func_151368_a(user, target, level);
        }
    }

    public void func_151367_b(EntityLivingBase user, Entity attacker, int level) {
        if (this.onUserHurt != null) {
            this.onUserHurt.handle(this.thisDefinition, CraftTweakerMC.getIEntityLivingBase((EntityLivingBase)user), CraftTweakerMC.getIEntity((Entity)attacker), level);
        } else {
            super.func_151367_b(user, attacker, level);
        }
    }

    public boolean func_185261_e() {
        return this.treasure;
    }

    public boolean func_190936_d() {
        return this.curse;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        if (this.applyAtEnchTable != null) {
            return this.applyAtEnchTable.handle(this.thisDefinition, CraftTweakerMC.getIItemStack((ItemStack)stack));
        }
        return super.canApplyAtEnchantingTable(stack);
    }

    public boolean isAllowedOnBooks() {
        return this.allowedOnBooks;
    }

    protected boolean func_77326_a(Enchantment ench) {
        if (this.canApplyTogether != null) {
            return this.canApplyTogether.handle(this.thisDefinition, (IEnchantmentDefinition)new MCEnchantmentDefinition(ench));
        }
        return super.func_77326_a(ench);
    }
}

