/*
 * Decompiled with CFR 0.152.
 */
package com.teamacronymcoders.contenttweaker.api.ctobjects.blockstate;

import com.teamacronymcoders.contenttweaker.api.ctobjects.blockpos.IBlockPos;
import com.teamacronymcoders.contenttweaker.api.ctobjects.blockstate.ICTBlockState;
import com.teamacronymcoders.contenttweaker.api.ctobjects.enums.Facing;
import com.teamacronymcoders.contenttweaker.api.ctobjects.enums.PushReaction;
import com.teamacronymcoders.contenttweaker.api.ctobjects.world.IWorld;
import crafttweaker.api.block.IBlock;
import crafttweaker.mc1120.block.MCSpecificBlock;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class MCBlockState
implements ICTBlockState {
    private IBlockState blockState;
    private IBlock block;

    public MCBlockState(IBlock block) {
        this.block = block;
        Block actualBlock = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(block.getDefinition().getId()));
        if (actualBlock != null) {
            this.blockState = actualBlock.func_176203_a(block.getMeta());
        }
    }

    public MCBlockState(IBlockState blockState) {
        this.blockState = blockState;
        Block block = blockState.func_177230_c();
        int meta = block.func_176201_c(blockState);
        this.block = new MCSpecificBlock(block, meta);
    }

    @Override
    public IBlock getBlock() {
        return this.block;
    }

    @Override
    public int getMeta() {
        return this.getBlock().getMeta();
    }

    @Override
    public boolean isReplaceable(IWorld world, IBlockPos blockPos) {
        return this.blockState.func_177230_c().func_176200_f((IBlockAccess)world.getInternal(), (BlockPos)blockPos.getInternal());
    }

    @Override
    public int getLightValue(IWorld world, IBlockPos blockPos) {
        return this.blockState.getLightValue((IBlockAccess)world.getInternal(), (BlockPos)blockPos.getInternal());
    }

    @Override
    public boolean canProvidePower() {
        return this.blockState.func_185897_m();
    }

    @Override
    public int getWeakPower(IWorld world, IBlockPos blockPos, Facing facing) {
        return this.blockState.func_185911_a((IBlockAccess)world.getInternal(), (BlockPos)blockPos.getInternal(), facing.getInternal());
    }

    @Override
    public int getComparatorInputOverride(IWorld world, IBlockPos blockPos) {
        return this.blockState.func_185888_a((World)world.getInternal(), (BlockPos)blockPos.getInternal());
    }

    @Override
    public PushReaction getMobilityFlag() {
        return PushReaction.of(this.blockState.func_185905_o());
    }

    @Override
    public int compare(ICTBlockState other) {
        int result = 0;
        if (!this.getInternal().equals(other.getInternal())) {
            if (this.getInternal().func_177230_c().equals(((IBlockState)other.getInternal()).func_177230_c())) {
                result = Integer.compare(this.getMeta(), other.getMeta());
            } else {
                int blockId = ((ForgeRegistry)ForgeRegistries.BLOCKS).getID((IForgeRegistryEntry)this.getInternal().func_177230_c());
                int otherBlockId = ((ForgeRegistry)ForgeRegistries.BLOCKS).getID((IForgeRegistryEntry)((IBlockState)other.getInternal()).func_177230_c());
                result = Integer.compare(blockId, otherBlockId);
            }
        }
        return result;
    }

    @Override
    public IBlockState getInternal() {
        return this.blockState;
    }
}

