/*
 * Decompiled with CFR 0.152.
 */
package bre.smoothfont.util;

import bre.smoothfont.config.GlobalConfig;
import bre.smoothfont.util.Logger;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.util.Hashtable;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraftforge.fml.client.SplashProgress;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.ContextCapabilities;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GLContext;

public class GLUtils {
    public static boolean anisotropicFilterSupported = false;
    public static boolean glGenerateMipmapSupported = false;
    public static boolean shaderSupported = false;
    private static Color4f prevColor = new Color4f();

    private static void setTextureBlur(boolean blur, boolean mipmap) {
        if (blur) {
            GlStateManager.func_187421_b((int)3553, (int)10241, (int)(mipmap ? 9987 : 9729));
            GlStateManager.func_187421_b((int)3553, (int)10240, (int)9729);
        } else {
            GlStateManager.func_187421_b((int)3553, (int)10241, (int)(mipmap ? 9986 : 9728));
            GlStateManager.func_187421_b((int)3553, (int)10240, (int)9728);
        }
    }

    private static void setTextureClamp(boolean clamp) {
        if (clamp) {
            GlStateManager.func_187421_b((int)3553, (int)10242, (int)10496);
            GlStateManager.func_187421_b((int)3553, (int)10243, (int)10496);
        } else {
            GlStateManager.func_187421_b((int)3553, (int)10242, (int)10497);
            GlStateManager.func_187421_b((int)3553, (int)10243, (int)10497);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void allocateTexture(int glTextureId, int mipmapLevels, int width, int height, boolean grayscale) {
        Class<SplashProgress> clazz = SplashProgress.class;
        synchronized (SplashProgress.class) {
            TextureUtil.func_147942_a((int)glTextureId);
            GlStateManager.func_179144_i((int)glTextureId);
            // ** MonitorExit[var5_5] (shouldn't be in output)
            if (mipmapLevels >= 0) {
                GlStateManager.func_187421_b((int)3553, (int)33085, (int)mipmapLevels);
                GlStateManager.func_187421_b((int)3553, (int)33082, (int)0);
                GlStateManager.func_187421_b((int)3553, (int)33083, (int)mipmapLevels);
                GlStateManager.func_187403_b((int)3553, (int)34049, (float)0.0f);
            }
            for (int i = 0; i <= mipmapLevels; ++i) {
                if (grayscale) {
                    GL11.glTexImage2D((int)3553, (int)i, (int)6406, (int)(width >> i), (int)(height >> i), (int)0, (int)6406, (int)5121, (ByteBuffer)null);
                    continue;
                }
                GL11.glTexImage2D((int)3553, (int)i, (int)32993, (int)(width >> i), (int)(height >> i), (int)0, (int)32993, (int)5121, (ByteBuffer)null);
            }
            return;
        }
    }

    public static int uploadTextureImage(int textureId, BufferedImage image, int xOffset, int yOffset, boolean blur, boolean clamp) {
        GlStateManager.func_179144_i((int)textureId);
        GLUtils.uploadTextureImage(image, xOffset, yOffset, blur, clamp);
        return textureId;
    }

    private static void uploadTextureImage(BufferedImage image, int xOffset, int yOffset, boolean blur, boolean clamp) {
        int width = image.getWidth();
        int height = image.getHeight();
        int bands = image.getType() == 10 ? 1 : 4;
        WritableRaster raster = Raster.createInterleavedRaster(0, width, height, bands, null);
        ColorModel colorModel = image.getColorModel();
        BufferedImage texImage = new BufferedImage(colorModel, raster, false, new Hashtable());
        DataBufferByte imageBuffer = (DataBufferByte)texImage.getRaster().getDataBuffer();
        ByteBuffer byteBuf = ByteBuffer.allocateDirect(imageBuffer.getSize());
        int[] bytes = new int[bands];
        byteBuf.order(ByteOrder.nativeOrder());
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                image.getRaster().getPixel(x, y, bytes);
                if (image.getType() == 10) {
                    byteBuf.put((byte)bytes[0]);
                    continue;
                }
                byteBuf.put((byte)bytes[2]);
                byteBuf.put((byte)bytes[1]);
                byteBuf.put((byte)bytes[0]);
                byteBuf.put((byte)bytes[3]);
            }
        }
        byteBuf.flip();
        GLUtils.setTextureBlur(blur, false);
        GLUtils.setTextureClamp(clamp);
        if (image.getType() == 10) {
            GL11.glTexSubImage2D((int)3553, (int)0, (int)xOffset, (int)yOffset, (int)width, (int)height, (int)6406, (int)5121, (ByteBuffer)byteBuf);
        } else {
            GL11.glTexSubImage2D((int)3553, (int)0, (int)xOffset, (int)yOffset, (int)width, (int)height, (int)32993, (int)5121, (ByteBuffer)byteBuf);
        }
    }

    private static boolean checkAnisotropicFilterSupported() throws RuntimeException {
        ContextCapabilities capabilities = GLContext.getCapabilities();
        return capabilities.GL_EXT_texture_filter_anisotropic;
    }

    private static boolean checkShaderSupported() throws RuntimeException {
        ContextCapabilities capabilities = GLContext.getCapabilities();
        return capabilities.OpenGL20;
    }

    private static boolean checkGlGenerateMipmapSupported() throws RuntimeException {
        ContextCapabilities capabilities = GLContext.getCapabilities();
        return capabilities.OpenGL30;
    }

    public static void checkGlFuncSupported() {
        try {
            anisotropicFilterSupported = GLUtils.checkAnisotropicFilterSupported();
            if (!anisotropicFilterSupported) {
                Logger.info("GL_EXT_texture_filter_anisotropic not supported.");
            }
            if (!(glGenerateMipmapSupported = GLUtils.checkGlGenerateMipmapSupported())) {
                Logger.info("GL30.glGenerateMipmap not supported.");
            }
            if (!(shaderSupported = GLUtils.checkShaderSupported())) {
                Logger.info("GL20 shader not supported.");
            }
        }
        catch (RuntimeException re) {
            re.printStackTrace();
        }
    }

    public static void saveColor() {
        if (!GlobalConfig.hasDebugOption("errorCorrection")) {
            return;
        }
        FloatBuffer floatBuf = BufferUtils.createFloatBuffer((int)16);
        GL11.glGetFloat((int)2816, (FloatBuffer)floatBuf);
        floatBuf.rewind();
        GLUtils.prevColor.r = floatBuf.get();
        GLUtils.prevColor.g = floatBuf.get();
        GLUtils.prevColor.b = floatBuf.get();
        GLUtils.prevColor.a = floatBuf.get();
        GLUtils.prevColor.saved = true;
    }

    public static void setColor(float r, float g, float b, float a) {
        if (!GlobalConfig.hasDebugOption("errorCorrection")) {
            return;
        }
        GlStateManager.func_179131_c((float)r, (float)g, (float)b, (float)a);
    }

    public static void blendColor(float r, float g, float b, float a) {
        if (!GlobalConfig.hasDebugOption("errorCorrection")) {
            return;
        }
        if (GLUtils.prevColor.saved) {
            r = r >= 0.0f ? (r + GLUtils.prevColor.r) / 2.0f : GLUtils.prevColor.r;
            g = g >= 0.0f ? (g + GLUtils.prevColor.g) / 2.0f : GLUtils.prevColor.g;
            b = b >= 0.0f ? (b + GLUtils.prevColor.b) / 2.0f : GLUtils.prevColor.b;
            a = a >= 0.0f ? (a + GLUtils.prevColor.a) / 2.0f : GLUtils.prevColor.a;
            GlStateManager.func_179131_c((float)r, (float)g, (float)b, (float)a);
        }
    }

    public static void restoreColor() {
        if (!GlobalConfig.hasDebugOption("errorCorrection")) {
            return;
        }
        if (GLUtils.prevColor.saved) {
            GlStateManager.func_179131_c((float)GLUtils.prevColor.r, (float)GLUtils.prevColor.g, (float)GLUtils.prevColor.b, (float)GLUtils.prevColor.a);
            GLUtils.prevColor.saved = false;
        }
    }

    private static class Color4f {
        float r;
        float g;
        float b;
        float a;
        boolean saved = false;

        private Color4f() {
        }
    }
}

