/*
 * Decompiled with CFR 0.152.
 */
package bre.smoothfont;

import bre.smoothfont.FontRasterizer;
import bre.smoothfont.FontUtils;
import bre.smoothfont.config.GlobalConfig;
import bre.smoothfont.util.GLUtils;
import bre.smoothfont.util.Logger;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.util.math.MathHelper;

public class ErrorCorrector {
    private float nextHighPosX = Float.MAX_VALUE;
    private float nextNormPosX = Float.MAX_VALUE;
    private float nextNormPosY;
    private float prevHighPosX = Float.MAX_VALUE;
    private float prevNormPosX = Float.MAX_VALUE;
    private static float[] charWidthError = new float[256];
    private static float[] glyphWidthError = new float[65536];
    public static float charWidthErrAverage;
    public static float glyphWidthErrAverage;
    private static float charWidthCorrection;
    private static float charWidthCorrectionHead;
    private static float glyphWidthCorrection;
    private static float glyphWidthCorrectionHead;
    public static FontRasterizer rasterizer;
    private static Map<Character, Float> letterFreq;

    public ErrorCorrector() {
        if (GlobalConfig.debug) {
            float total = 0.0f;
            for (char ch : "abcdefghijklmnopqrstuvwxyz".toCharArray()) {
                total += letterFreq.get(Character.valueOf(ch)).floatValue();
            }
            Logger.debug("Letter frequency total = " + total);
        }
    }

    public float getCorrectedPosX(float posX, float posY, float width, int fontRes, boolean bold, boolean unicode) {
        boolean head = false;
        if (posY == this.nextNormPosY && posX == this.nextNormPosX) {
            posX = this.nextHighPosX;
        } else if (bold) {
            posX = this.prevHighPosX + 0.5f;
            this.nextHighPosX = this.prevHighPosX + 1.0f;
            this.nextNormPosX = this.prevNormPosX + 1.0f;
        } else {
            this.nextHighPosX = posX;
            this.nextNormPosX = posX;
            this.nextNormPosY = posY;
            head = true;
        }
        this.prevHighPosX = this.nextHighPosX;
        this.prevNormPosX = this.nextNormPosX;
        this.nextHighPosX += width;
        this.nextNormPosX += (float)FontUtils.toNormalWidth(width);
        float adjustVal = unicode ? (head ? glyphWidthCorrectionHead : glyphWidthCorrection) : (head ? charWidthCorrectionHead : charWidthCorrection);
        float correction = this.nextHighPosX > this.nextNormPosX ? -adjustVal : 0.0f;
        this.nextHighPosX += correction;
        if (GlobalConfig.hasDebugOption("errorCorrection")) {
            boolean changeColor = false;
            float b = 0.0f;
            float g = 0.0f;
            float r = 0.0f;
            float a = -1.0f;
            if (head) {
                g = 1.0f;
                r = 1.0f;
                changeColor = true;
            }
            if (correction != 0.0f) {
                if (head) {
                    b = 0.0f;
                    r = 0.0f;
                    g = 1.0f;
                } else {
                    r = 0.0f;
                    b = 1.0f;
                    g = 1.0f;
                }
                changeColor = true;
            }
            if (changeColor) {
                GLUtils.saveColor();
                GLUtils.blendColor(r, g, b, a);
            }
        }
        return posX;
    }

    public static void calcErrorAverage(int fontRes) {
        String sampleChars = "abcdefghijklmnopqrstuvwxyz";
        float totalCharWidthError = 0.0f;
        float totalGlyphWidthError = 0.0f;
        for (char ch : sampleChars.toCharArray()) {
            int id = FontUtils.getDefaultGlyphIndex(ch);
            totalCharWidthError += charWidthError[id] * letterFreq.get(Character.valueOf(ch)).floatValue();
            totalGlyphWidthError += glyphWidthError[ch] * letterFreq.get(Character.valueOf(ch)).floatValue();
        }
        charWidthErrAverage = totalCharWidthError;
        glyphWidthErrAverage = totalGlyphWidthError;
        Logger.debug("Average charWidth error = ", Float.valueOf(charWidthErrAverage));
        Logger.debug("Average glyphWidth error = ", Float.valueOf(glyphWidthErrAverage));
        if (fontRes == 12 || fontRes == 24 || fontRes == 48) {
            if (charWidthErrAverage < -0.3333333f) {
                charWidthCorrection = 0.5f;
                charWidthCorrectionHead = 0.3333333f;
            } else {
                charWidthCorrection = 0.3333333f;
                charWidthCorrectionHead = 0.0f;
            }
            if (glyphWidthErrAverage < -0.3333333f) {
                glyphWidthCorrection = 0.5f;
                glyphWidthCorrectionHead = 0.3333333f;
            } else {
                glyphWidthCorrection = 0.3333333f;
                glyphWidthCorrectionHead = 0.0f;
            }
        } else {
            if (charWidthErrAverage < -0.25f) {
                charWidthCorrection = 0.5f;
                charWidthCorrectionHead = 0.25f;
            } else {
                charWidthCorrection = 0.25f;
                charWidthCorrectionHead = 0.0f;
            }
            if (glyphWidthErrAverage < -0.25f) {
                glyphWidthCorrection = 0.5f;
                glyphWidthCorrectionHead = 0.25f;
            } else {
                glyphWidthCorrection = 0.25f;
                glyphWidthCorrectionHead = 0.0f;
            }
        }
    }

    public static float getCorrectedSpaceWidth(boolean unicodeFlag) {
        float width = unicodeFlag ? (glyphWidthErrAverage < 0.0f ? (float)((int)ErrorCorrector.rasterizer.glyphWidthFloat8[32]) + 1.0f : (float)MathHelper.func_76123_f((float)ErrorCorrector.rasterizer.glyphWidthFloat8[32])) : (charWidthErrAverage < 0.0f ? (float)((int)ErrorCorrector.rasterizer.charWidthFloat[32]) + 1.0f : (float)MathHelper.func_76123_f((float)ErrorCorrector.rasterizer.charWidthFloat[32]));
        return width;
    }

    public static void setCharWidthError(int id, float width) {
        ErrorCorrector.charWidthError[id] = width == 0.0f ? 0.0f : (float)FontUtils.toNormalWidth(width) - width;
    }

    public static void setGlyphWidthError(int ch, float width) {
        ErrorCorrector.glyphWidthError[ch] = width == 0.0f ? 0.0f : (float)FontUtils.toNormalWidth(width) - width;
    }

    static {
        rasterizer = FontRasterizer.getInstance();
        letterFreq = new HashMap<Character, Float>(){
            {
                this.put(Character.valueOf('a'), Float.valueOf(0.08167f));
                this.put(Character.valueOf('b'), Float.valueOf(0.01492f));
                this.put(Character.valueOf('c'), Float.valueOf(0.02782f));
                this.put(Character.valueOf('d'), Float.valueOf(0.04253f));
                this.put(Character.valueOf('e'), Float.valueOf(0.12702f));
                this.put(Character.valueOf('f'), Float.valueOf(0.02228f));
                this.put(Character.valueOf('g'), Float.valueOf(0.02015f));
                this.put(Character.valueOf('h'), Float.valueOf(0.06094f));
                this.put(Character.valueOf('i'), Float.valueOf(0.06966f));
                this.put(Character.valueOf('j'), Float.valueOf(0.00153f));
                this.put(Character.valueOf('k'), Float.valueOf(0.00772f));
                this.put(Character.valueOf('l'), Float.valueOf(0.04025f));
                this.put(Character.valueOf('m'), Float.valueOf(0.02406f));
                this.put(Character.valueOf('n'), Float.valueOf(0.06749f));
                this.put(Character.valueOf('o'), Float.valueOf(0.07507f));
                this.put(Character.valueOf('p'), Float.valueOf(0.01929f));
                this.put(Character.valueOf('q'), Float.valueOf(9.5E-4f));
                this.put(Character.valueOf('r'), Float.valueOf(0.05987f));
                this.put(Character.valueOf('s'), Float.valueOf(0.06327f));
                this.put(Character.valueOf('t'), Float.valueOf(0.09056f));
                this.put(Character.valueOf('u'), Float.valueOf(0.02758f));
                this.put(Character.valueOf('v'), Float.valueOf(0.00978f));
                this.put(Character.valueOf('w'), Float.valueOf(0.0236f));
                this.put(Character.valueOf('x'), Float.valueOf(0.0015f));
                this.put(Character.valueOf('y'), Float.valueOf(0.01972f));
                this.put(Character.valueOf('z'), Float.valueOf(7.4E-4f));
            }
        };
    }
}

