/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.utils.apihandlers.crafttweaker;

import com.buuz135.industrial.api.recipe.FluidDictionaryEntry;
import com.buuz135.industrial.utils.apihandlers.RecipeHandlers;
import com.buuz135.industrial.utils.apihandlers.crafttweaker.CTAction;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.industrialforegoing.FluidDictionary")
public class CTFluidDictionary {
    @ZenMethod
    public static void add(String fluidInput, String fluidOutput, double ratio) {
        CraftTweakerAPI.apply((IAction)new Add(new FluidDictionaryEntry(fluidInput, fluidOutput, ratio)));
    }

    @ZenMethod
    public static void remove(String fluidInput, String fluidOutput) {
        CraftTweakerAPI.apply((IAction)new Remove(fluidInput, fluidOutput));
    }

    private static class Remove
    implements IAction {
        private final String origin;
        private final String result;

        private Remove(String origin, String result) {
            this.origin = origin;
            this.result = result;
        }

        public void apply() {
            RecipeHandlers.FLUID_DICTIONARY_ENTRIES.put((Object)CTAction.REMOVE, (Object)new FluidDictionaryEntry(this.origin, this.result, 0.0));
        }

        public String describe() {
            return "Removing  FluidDictionary Entry " + this.origin + " " + this.result;
        }
    }

    private static class Add
    implements IAction {
        private final FluidDictionaryEntry entry;

        private Add(FluidDictionaryEntry entry) {
            this.entry = entry;
        }

        public void apply() {
            RecipeHandlers.FLUID_DICTIONARY_ENTRIES.put((Object)CTAction.ADD, (Object)this.entry);
        }

        public String describe() {
            return "Adding FluidDictionary Entry " + this.entry.getFluidOrigin() + " * " + this.entry.getRatio() + " = " + this.entry.getFluidResult();
        }
    }
}

