/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.tile.block;

import com.buuz135.industrial.api.book.IPage;
import com.buuz135.industrial.api.book.page.PageItemList;
import com.buuz135.industrial.api.recipe.BioReactorEntry;
import com.buuz135.industrial.api.recipe.IReactorEntry;
import com.buuz135.industrial.book.BookCategory;
import com.buuz135.industrial.config.CustomConfiguration;
import com.buuz135.industrial.proxy.ItemRegistry;
import com.buuz135.industrial.tile.block.CustomOrientedBlock;
import com.buuz135.industrial.tile.generator.BioReactorTile;
import com.buuz135.industrial.utils.RecipeUtils;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.ndrei.teslacorelib.items.MachineCaseItem;

public class BioReactorBlock
extends CustomOrientedBlock<BioReactorTile> {
    private int baseAmount;

    public BioReactorBlock() {
        super("bioreactor", BioReactorTile.class, Material.field_151576_e, 2000, 10);
    }

    @Override
    public void getMachineConfig() {
        super.getMachineConfig();
        this.baseAmount = CustomConfiguration.config.getInt("baseBiofuel", "machines." + this.getRegistryName().func_110623_a().toString(), 80, 1, 4000, "Base biofuel amount in mb");
    }

    public int getBaseAmount() {
        return this.baseAmount;
    }

    @Override
    public void createRecipe() {
        RecipeUtils.addShapedRecipe(new ItemStack((Block)this), new Object[]{"pep", "sms", "bcb", Character.valueOf('p'), ItemRegistry.plastic, Character.valueOf('e'), Items.field_151071_bq, Character.valueOf('s'), Items.field_151123_aH, Character.valueOf('m'), MachineCaseItem.INSTANCE, Character.valueOf('b'), Items.field_151118_aC, Character.valueOf('c'), Items.field_151102_aT});
    }

    @Override
    public BookCategory getCategory() {
        return BookCategory.GENERATORS;
    }

    @Override
    public List<IPage> getBookDescriptionPages() {
        List<IPage> pages = super.getBookDescriptionPages();
        pages.addAll(PageItemList.generatePagesFromItemStacks(BioReactorEntry.BIO_REACTOR_ENTRIES.stream().map(IReactorEntry::getStack).collect(Collectors.toList()), I18n.func_135052_a((String)"text.book.accepted_items", (Object[])new Object[0])));
        return pages;
    }
}

