/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.lttweaker;

import java.util.List;
import java.util.Map;
import net.darkhax.lttweaker.LTTMod;
import net.darkhax.lttweaker.libs.Constants;
import net.darkhax.lttweaker.libs.LootEntryItemContext;
import net.darkhax.lttweaker.libs.TableBuilder;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootEntryItem;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTable;
import org.apache.commons.lang3.SystemUtils;

public class CommandTableDump
extends CommandBase {
    public String func_71517_b() {
        return "dumploot";
    }

    public String func_71518_a(ICommandSender sender) {
        return "none";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        sender.func_145747_a((ITextComponent)new TextComponentTranslation("command.loottabletweaks.startdump", new Object[0]));
        for (Map.Entry<String, LootTable> table : LTTMod.tables.entrySet()) {
            Constants.LOG.info("## " + table.getKey());
            List<LootPool> thePools = LTTMod.getPools(table.getValue());
            if (thePools.isEmpty()) {
                Constants.LOG.info("No entries for this table!");
            } else {
                TableBuilder<LootEntryItemContext> output = new TableBuilder<LootEntryItemContext>();
                output.addColumn("Pool Name", LootEntryItemContext::getPoolName);
                output.addColumn("Entry Name", LootEntryItemContext::getEntryName);
                output.addColumn("Item ID", LootEntryItemContext::getItemName);
                output.addColumn("Weight", LootEntryItemContext::getWeight);
                for (LootPool pool : thePools) {
                    for (LootEntry entry : LTTMod.getLootEntries(pool)) {
                        if (!(entry instanceof LootEntryItem)) continue;
                        output.addEntry(new LootEntryItemContext(pool, (LootEntryItem)entry));
                    }
                }
                Constants.LOG.info(SystemUtils.LINE_SEPARATOR + output.createString());
            }
            Constants.LOG.info(SystemUtils.LINE_SEPARATOR);
        }
        sender.func_145747_a((ITextComponent)new TextComponentTranslation("command.loottabletweaks.enddump", new Object[0]));
    }
}

