/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.recipe.xml;

import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.oredict.ShapedOreRecipe;
import org.cyclops.cyclopscore.helper.CraftingHelpers;
import org.cyclops.cyclopscore.init.RecipeHandler;
import org.cyclops.cyclopscore.recipe.xml.GridRecipeTypeHandler;
import org.cyclops.cyclopscore.recipe.xml.XmlRecipeLoader;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ShapedRecipeTypeHandler
extends GridRecipeTypeHandler {
    @Override
    protected NonNullList<Ingredient> handleIO(RecipeHandler recipeHandler, Element input, ItemStack output) throws XmlRecipeLoader.XmlRecipeException {
        Element inputGrid = (Element)input.getElementsByTagName("grid").item(0);
        NodeList gridRows = inputGrid.getElementsByTagName("gridrow");
        NonNullList inputs = NonNullList.func_191196_a();
        CraftingHelper.ShapedPrimer shape = new CraftingHelper.ShapedPrimer();
        shape.height = 0;
        shape.width = 0;
        shape.input = NonNullList.func_191196_a();
        for (int row = 0; row < gridRows.getLength(); ++row) {
            ++shape.height;
            Element gridRow = (Element)gridRows.item(row);
            NodeList gridColumns = gridRow.getElementsByTagName("item");
            for (int col = 0; col < gridColumns.getLength(); ++col) {
                if (row == 0) {
                    ++shape.width;
                }
                Node gridColumn = gridColumns.item(col);
                shape.input.add((Object)this.getIngredient(recipeHandler, gridColumn));
            }
        }
        ResourceLocation id = CraftingHelpers.newRecipeIdentifier(output);
        CraftingHelpers.registerRecipe(id, (IRecipe)new ShapedOreRecipe(id, output, shape));
        return inputs;
    }
}

