/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.init;

import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.RecipeSorter;
import org.cyclops.cyclopscore.GeneralConfig;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.cyclopscore.recipe.custom.api.IRecipe;
import org.cyclops.cyclopscore.recipe.event.ObservableShapedRecipe;
import org.cyclops.cyclopscore.recipe.event.ObservableShapelessRecipe;
import org.cyclops.cyclopscore.recipe.xml.ConfigRecipeConditionHandler;
import org.cyclops.cyclopscore.recipe.xml.FluidConditionHandler;
import org.cyclops.cyclopscore.recipe.xml.IRecipeConditionHandler;
import org.cyclops.cyclopscore.recipe.xml.IRecipeTypeHandler;
import org.cyclops.cyclopscore.recipe.xml.ItemConditionHandler;
import org.cyclops.cyclopscore.recipe.xml.ModRecipeConditionHandler;
import org.cyclops.cyclopscore.recipe.xml.OreDictConditionHandler;
import org.cyclops.cyclopscore.recipe.xml.PredefinedRecipeConditionHandler;
import org.cyclops.cyclopscore.recipe.xml.ShapedRecipeTypeHandler;
import org.cyclops.cyclopscore.recipe.xml.ShapelessRecipeTypeHandler;
import org.cyclops.cyclopscore.recipe.xml.SmeltingRecipeTypeHandler;
import org.cyclops.cyclopscore.recipe.xml.XmlRecipeLoader;

public class RecipeHandler {
    private final Multimap<String, IRecipe> taggedRecipes = LinkedListMultimap.create();
    private final Map<String, IRecipeTypeHandler> recipeTypeHandlers = Maps.newHashMap();
    private final Map<String, IRecipeConditionHandler> recipeConditionHandlers = Maps.newHashMap();
    private final Map<String, ItemStack> predefinedItems = Maps.newHashMap();
    private final Set<String> predefinedValues = Sets.newHashSet();
    private final ModBase mod;
    private final List<String> recipeFiles;
    private final AtomicReference<Object> externalRecipesPattern = new AtomicReference();
    private final AtomicReference<Object> externalRecipesOverridesPattern = new AtomicReference();

    public RecipeHandler(ModBase mod, String ... fileNames) {
        this.mod = mod;
        this.recipeFiles = Lists.newArrayList((Object[])fileNames);
        this.registerHandlers(this.recipeTypeHandlers, this.recipeConditionHandlers);
    }

    protected void registerHandlers(Map<String, IRecipeTypeHandler> recipeTypeHandlers, Map<String, IRecipeConditionHandler> recipeConditionHandlers) {
        recipeTypeHandlers.put("shaped", new ShapedRecipeTypeHandler());
        recipeTypeHandlers.put("shapeless", new ShapelessRecipeTypeHandler());
        recipeTypeHandlers.put("smelting", new SmeltingRecipeTypeHandler());
        recipeConditionHandlers.put("config", new ConfigRecipeConditionHandler());
        recipeConditionHandlers.put("predefined", new PredefinedRecipeConditionHandler());
        recipeConditionHandlers.put("mod", new ModRecipeConditionHandler());
        recipeConditionHandlers.put("oredict", new OreDictConditionHandler());
        recipeConditionHandlers.put("fluid", new FluidConditionHandler());
        recipeConditionHandlers.put("item", new ItemConditionHandler());
    }

    protected XmlRecipeLoader constructXmlRecipeLoader(InputStream is, String fileName) {
        return new XmlRecipeLoader(this.getMod(), is, fileName, this);
    }

    protected XmlRecipeLoader registerRecipesForFile(InputStream is, String fileName, boolean canOverride) throws XmlRecipeLoader.XmlRecipeException {
        return this.constructXmlRecipeLoader(is, fileName);
    }

    protected List<XmlRecipeLoader> registerRecipesForFiles(File file, Map<String, XmlRecipeLoader> internalLoaders, boolean canOverride) throws XmlRecipeLoader.XmlRecipeException {
        File[] childFiles;
        if (file.isFile() && this.getExternalRecipesPattern().matcher(file.getName()).matches()) {
            try {
                XmlRecipeLoader loader = this.registerRecipesForFile(new FileInputStream(file), file.getName(), canOverride);
                if (!internalLoaders.containsKey(file.getName()) || !canOverride) {
                    return Lists.newArrayList((Object[])new XmlRecipeLoader[]{loader});
                }
                internalLoaders.put(file.getName(), loader);
            }
            catch (FileNotFoundException loader) {}
        } else if (file.isDirectory() && (childFiles = file.listFiles()) != null) {
            LinkedList loaders = Lists.newLinkedList();
            for (File childFile : childFiles) {
                loaders.addAll(this.registerRecipesForFiles(childFile, internalLoaders, this.getExternalRecipesOverridesPattern().matcher(file.getName()).matches()));
            }
            return loaders;
        }
        return Collections.emptyList();
    }

    private void loadAllRecipes(Collection<XmlRecipeLoader> loaders) {
        for (XmlRecipeLoader loader : loaders) {
            InputStream xsdIs = RecipeHandler.class.getResourceAsStream(this.getRecipesXsdPath());
            loader.setValidator(xsdIs);
            loader.loadRecipes(GeneralConfig.crashOnInvalidRecipe);
        }
    }

    protected String getRecipesBasePath() {
        return "/assets/" + this.getMod().getModId() + "/recipes/";
    }

    protected String getRecipesXsdPath() {
        return "/assets/cyclopscore/recipes/recipes.xsd";
    }

    public final void registerRecipes(File rootConfigFolder) throws XmlRecipeLoader.XmlRecipeException {
        this.registerRecipeSorters();
        this.loadPredefineds(this.getPredefinedItems(), this.getPredefinedValues());
        HashMap internalLoaders = Maps.newHashMapWithExpectedSize((int)this.getRecipeFiles().size());
        for (String file : this.getRecipeFiles()) {
            InputStream is = RecipeHandler.class.getResourceAsStream(this.getRecipesBasePath() + file);
            internalLoaders.put(file, this.registerRecipesForFile(is, file, false));
        }
        List<XmlRecipeLoader> externalLoaders = this.registerRecipesForFiles(rootConfigFolder, internalLoaders, false);
        this.loadAllRecipes(internalLoaders.values());
        this.loadAllRecipes(externalLoaders);
        this.registerCustomRecipes();
    }

    protected void registerRecipeSorters() {
        RecipeSorter.register((String)(this.getMod().getModId() + "observableshapeless"), ObservableShapelessRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"after:forge:shapelessore");
        RecipeSorter.register((String)(this.getMod().getModId() + "observableshaped"), ObservableShapedRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"after:forge:shapedore");
    }

    protected void loadPredefineds(Map<String, ItemStack> predefinedItems, Set<String> predefinedValues) {
    }

    protected void registerCustomRecipes() {
    }

    public ItemStack getPredefinedItem(String key) {
        return this.predefinedItems.get(key);
    }

    public boolean isPredefinedValue(String value) {
        return this.predefinedValues.contains(value);
    }

    public Multimap<String, IRecipe> getTaggedRecipes() {
        return this.taggedRecipes;
    }

    public Map<String, IRecipeTypeHandler> getRecipeTypeHandlers() {
        return this.recipeTypeHandlers;
    }

    public Map<String, IRecipeConditionHandler> getRecipeConditionHandlers() {
        return this.recipeConditionHandlers;
    }

    public Map<String, ItemStack> getPredefinedItems() {
        return this.predefinedItems;
    }

    public Set<String> getPredefinedValues() {
        return this.predefinedValues;
    }

    public ModBase getMod() {
        return this.mod;
    }

    public List<String> getRecipeFiles() {
        return this.recipeFiles;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RecipeHandler)) {
            return false;
        }
        RecipeHandler other = (RecipeHandler)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Multimap<String, IRecipe> this$taggedRecipes = this.getTaggedRecipes();
        Multimap<String, IRecipe> other$taggedRecipes = other.getTaggedRecipes();
        if (this$taggedRecipes == null ? other$taggedRecipes != null : !this$taggedRecipes.equals(other$taggedRecipes)) {
            return false;
        }
        Map<String, IRecipeTypeHandler> this$recipeTypeHandlers = this.getRecipeTypeHandlers();
        Map<String, IRecipeTypeHandler> other$recipeTypeHandlers = other.getRecipeTypeHandlers();
        if (this$recipeTypeHandlers == null ? other$recipeTypeHandlers != null : !((Object)this$recipeTypeHandlers).equals(other$recipeTypeHandlers)) {
            return false;
        }
        Map<String, IRecipeConditionHandler> this$recipeConditionHandlers = this.getRecipeConditionHandlers();
        Map<String, IRecipeConditionHandler> other$recipeConditionHandlers = other.getRecipeConditionHandlers();
        if (this$recipeConditionHandlers == null ? other$recipeConditionHandlers != null : !((Object)this$recipeConditionHandlers).equals(other$recipeConditionHandlers)) {
            return false;
        }
        Map<String, ItemStack> this$predefinedItems = this.getPredefinedItems();
        Map<String, ItemStack> other$predefinedItems = other.getPredefinedItems();
        if (this$predefinedItems == null ? other$predefinedItems != null : !((Object)this$predefinedItems).equals(other$predefinedItems)) {
            return false;
        }
        Set<String> this$predefinedValues = this.getPredefinedValues();
        Set<String> other$predefinedValues = other.getPredefinedValues();
        if (this$predefinedValues == null ? other$predefinedValues != null : !((Object)this$predefinedValues).equals(other$predefinedValues)) {
            return false;
        }
        ModBase this$mod = this.getMod();
        ModBase other$mod = other.getMod();
        if (this$mod == null ? other$mod != null : !((Object)this$mod).equals(other$mod)) {
            return false;
        }
        List<String> this$recipeFiles = this.getRecipeFiles();
        List<String> other$recipeFiles = other.getRecipeFiles();
        if (this$recipeFiles == null ? other$recipeFiles != null : !((Object)this$recipeFiles).equals(other$recipeFiles)) {
            return false;
        }
        Pattern this$externalRecipesPattern = this.getExternalRecipesPattern();
        Pattern other$externalRecipesPattern = other.getExternalRecipesPattern();
        if (this$externalRecipesPattern == null ? other$externalRecipesPattern != null : !this$externalRecipesPattern.equals(other$externalRecipesPattern)) {
            return false;
        }
        Pattern this$externalRecipesOverridesPattern = this.getExternalRecipesOverridesPattern();
        Pattern other$externalRecipesOverridesPattern = other.getExternalRecipesOverridesPattern();
        return !(this$externalRecipesOverridesPattern == null ? other$externalRecipesOverridesPattern != null : !this$externalRecipesOverridesPattern.equals(other$externalRecipesOverridesPattern));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RecipeHandler;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Multimap<String, IRecipe> $taggedRecipes = this.getTaggedRecipes();
        result = result * 59 + ($taggedRecipes == null ? 0 : $taggedRecipes.hashCode());
        Map<String, IRecipeTypeHandler> $recipeTypeHandlers = this.getRecipeTypeHandlers();
        result = result * 59 + ($recipeTypeHandlers == null ? 0 : ((Object)$recipeTypeHandlers).hashCode());
        Map<String, IRecipeConditionHandler> $recipeConditionHandlers = this.getRecipeConditionHandlers();
        result = result * 59 + ($recipeConditionHandlers == null ? 0 : ((Object)$recipeConditionHandlers).hashCode());
        Map<String, ItemStack> $predefinedItems = this.getPredefinedItems();
        result = result * 59 + ($predefinedItems == null ? 0 : ((Object)$predefinedItems).hashCode());
        Set<String> $predefinedValues = this.getPredefinedValues();
        result = result * 59 + ($predefinedValues == null ? 0 : ((Object)$predefinedValues).hashCode());
        ModBase $mod = this.getMod();
        result = result * 59 + ($mod == null ? 0 : ((Object)$mod).hashCode());
        List<String> $recipeFiles = this.getRecipeFiles();
        result = result * 59 + ($recipeFiles == null ? 0 : ((Object)$recipeFiles).hashCode());
        Pattern $externalRecipesPattern = this.getExternalRecipesPattern();
        result = result * 59 + ($externalRecipesPattern == null ? 0 : $externalRecipesPattern.hashCode());
        Pattern $externalRecipesOverridesPattern = this.getExternalRecipesOverridesPattern();
        result = result * 59 + ($externalRecipesOverridesPattern == null ? 0 : $externalRecipesOverridesPattern.hashCode());
        return result;
    }

    public String toString() {
        return "RecipeHandler(taggedRecipes=" + this.getTaggedRecipes() + ", recipeTypeHandlers=" + this.getRecipeTypeHandlers() + ", recipeConditionHandlers=" + this.getRecipeConditionHandlers() + ", predefinedItems=" + this.getPredefinedItems() + ", predefinedValues=" + this.getPredefinedValues() + ", mod=" + this.getMod() + ", recipeFiles=" + this.getRecipeFiles() + ", externalRecipesPattern=" + this.getExternalRecipesPattern() + ", externalRecipesOverridesPattern=" + this.getExternalRecipesOverridesPattern() + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pattern getExternalRecipesPattern() {
        Object value = this.externalRecipesPattern.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = this.externalRecipesPattern;
            synchronized (atomicReference) {
                value = this.externalRecipesPattern.get();
                if (value == null) {
                    Pattern actualValue = Pattern.compile("^[^_].*\\.xml");
                    value = actualValue == null ? this.externalRecipesPattern : actualValue;
                    this.externalRecipesPattern.set(value);
                }
            }
        }
        return (Pattern)(value == this.externalRecipesPattern ? null : value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pattern getExternalRecipesOverridesPattern() {
        Object value = this.externalRecipesOverridesPattern.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = this.externalRecipesOverridesPattern;
            synchronized (atomicReference) {
                value = this.externalRecipesOverridesPattern.get();
                if (value == null) {
                    Pattern actualValue = Pattern.compile("^_override$");
                    value = actualValue == null ? this.externalRecipesOverridesPattern : actualValue;
                    this.externalRecipesOverridesPattern.set(value);
                }
            }
        }
        return (Pattern)(value == this.externalRecipesOverridesPattern ? null : value);
    }
}

