/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.ingredient.collection;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponentCategoryType;
import org.cyclops.cyclopscore.ingredient.collection.IIngredientCollectionLikeMultiClassifiedTrait;
import org.cyclops.cyclopscore.ingredient.collection.IIngredientMap;
import org.cyclops.cyclopscore.ingredient.collection.IIngredientMapMutable;
import org.cyclops.cyclopscore.ingredient.collection.IngredientMapAdapter;
import org.cyclops.cyclopscore.ingredient.collection.IngredientMapSingleClassified;
import org.cyclops.cyclopscore.ingredient.collection.IngredientSet;

public class IngredientMapMultiClassified<T, M, V>
extends IngredientMapAdapter<T, M, V>
implements IIngredientMapMutable<T, M, V>,
IIngredientCollectionLikeMultiClassifiedTrait<T, M, Map.Entry<T, V>, IngredientMapSingleClassified<T, M, V, ?>> {
    private final Map<IngredientComponentCategoryType<T, M, ?>, IngredientMapSingleClassified<T, M, V, ?>> classifiedMaps = Maps.newIdentityHashMap();

    public IngredientMapMultiClassified(IngredientComponent<T, M> component, Supplier<IIngredientMapMutable<T, M, V>> mapCreator) {
        super(component);
        for (IngredientComponentCategoryType categoryType : component.getCategoryTypes()) {
            this.classifiedMaps.put(categoryType, new IngredientMapSingleClassified(component, mapCreator, categoryType));
        }
    }

    @Override
    public void clear() {
        for (IIngredientMapMutable iIngredientMapMutable : this.classifiedMaps.values()) {
            iIngredientMapMutable.clear();
        }
    }

    @Override
    @Nullable
    public V put(T key, V value) {
        V previous = null;
        for (IIngredientMapMutable iIngredientMapMutable : this.classifiedMaps.values()) {
            previous = iIngredientMapMutable.put(key, value);
        }
        return previous;
    }

    public int putAllThreaded(@Nullable ExecutorService executorService, IIngredientMap<? extends T, M, ? extends V> map) {
        boolean newExecutorService = false;
        if (executorService == null) {
            executorService = Executors.newFixedThreadPool(this.classifiedMaps.size());
            newExecutorService = true;
        }
        try {
            int ret = (Integer)executorService.invokeAll(this.classifiedMaps.values().stream().map(c -> () -> c.putAll(map)).collect(Collectors.toList())).get(0).get();
            if (newExecutorService) {
                executorService.shutdown();
            }
            return ret;
        }
        catch (InterruptedException | ExecutionException e) {
            e.printStackTrace();
            return 0;
        }
    }

    @Override
    @Nullable
    public V remove(T key) {
        V previous = null;
        for (IIngredientMapMutable iIngredientMapMutable : this.classifiedMaps.values()) {
            previous = iIngredientMapMutable.remove(key);
        }
        return previous;
    }

    @Override
    public int removeAll(T instance, M matchCondition) {
        if (matchCondition.equals(this.getComponent().getMatcher().getAnyMatchCondition())) {
            int size = this.size();
            this.clear();
            return size;
        }
        IngredientMapSingleClassified classifiedCollection = (IngredientMapSingleClassified)this.getBestClassifiedCollection(matchCondition);
        Set otherClassifiedCollections = Sets.newIdentityHashSet();
        otherClassifiedCollections.addAll(this.classifiedMaps.values());
        otherClassifiedCollections.remove(classifiedCollection);
        Iterator it = classifiedCollection.iterator(instance, matchCondition);
        int count = 0;
        while (it.hasNext()) {
            Map.Entry removed = it.next();
            it.remove();
            otherClassifiedCollections.forEach(c -> c.remove(removed.getKey()));
            ++count;
        }
        return count;
    }

    @Override
    public boolean containsValue(V value) {
        return ((IngredientMapSingleClassified)this.getFirstSingleClassified()).containsValue(value);
    }

    @Override
    public boolean containsKey(T instance, M matchCondition) {
        return ((IngredientMapSingleClassified)this.getBestClassifiedCollection(matchCondition)).containsKey(instance, matchCondition);
    }

    @Override
    public boolean containsKeyAll(Iterable<? extends T> instances, M matchCondition) {
        return ((IngredientMapSingleClassified)this.getBestClassifiedCollection(matchCondition)).containsKeyAll(instances, matchCondition);
    }

    @Override
    @Nullable
    public V get(T key) {
        return ((IngredientMapSingleClassified)this.getFirstSingleClassified()).get(key);
    }

    @Override
    public Collection<V> getAll(T key, M matchCondition) {
        return ((IngredientMapSingleClassified)this.getBestClassifiedCollection(matchCondition)).getAll(key, matchCondition);
    }

    @Override
    public IngredientSet<T, M> keySet() {
        return ((IngredientMapSingleClassified)this.getFirstSingleClassified()).keySet();
    }

    @Override
    public IngredientSet<T, M> keySet(T instance, M matchCondition) {
        return ((IngredientMapSingleClassified)this.getBestClassifiedCollection(matchCondition)).keySet(instance, matchCondition);
    }

    @Override
    public Collection<V> values() {
        return ((IngredientMapSingleClassified)this.getFirstSingleClassified()).values();
    }

    @Override
    public int size() {
        return ((IngredientMapSingleClassified)this.getFirstSingleClassified()).size();
    }

    @Override
    public Iterator<Map.Entry<T, V>> iterator() {
        return new IIngredientCollectionLikeMultiClassifiedTrait.RemoveCallbackIterator(this, null, this.getComponent().getMatcher().getAnyMatchCondition());
    }

    @Override
    public Iterator<Map.Entry<T, V>> iterator(T instance, M matchCondition) {
        return new IIngredientCollectionLikeMultiClassifiedTrait.RemoveCallbackIterator(this, instance, matchCondition);
    }

    @Override
    public void removeInstance(IngredientMapSingleClassified<T, M, V, ?> collection, Map.Entry<T, V> iterableInstance) {
        collection.remove(iterableInstance.getKey());
    }

    @Override
    public Map<IngredientComponentCategoryType<T, M, ?>, IngredientMapSingleClassified<T, M, V, ?>> getClassifiedCollections() {
        return this.classifiedMaps;
    }
}

