/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.client.render.tileentity;

import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import org.cyclops.cyclopscore.tileentity.CyclopsTileEntity;

public abstract class RenderTileEntityModel<T extends CyclopsTileEntity, M>
extends TileEntitySpecialRenderer<T> {
    protected final M model;
    private final ResourceLocation texture;

    public RenderTileEntityModel(M model, ResourceLocation texture) {
        this.model = model;
        this.texture = texture;
    }

    public ResourceLocation getTexture() {
        return this.texture;
    }

    protected void preRotate(T tile) {
        GlStateManager.func_179109_b((float)0.5f, (float)0.5f, (float)0.5f);
    }

    protected void postRotate(T tile) {
        GlStateManager.func_179109_b((float)-0.5f, (float)-0.5f, (float)-0.5f);
    }

    public void render(T tile, double x, double y, double z, float partialTick, int destroyStage, float alpha) {
        EnumFacing direction = ((CyclopsTileEntity)tile).getRotation();
        if (destroyStage >= 0) {
            this.func_147499_a(field_178460_a[destroyStage]);
            GlStateManager.func_179128_n((int)5890);
            GlStateManager.func_179094_E();
            GlStateManager.func_179152_a((float)4.0f, (float)4.0f, (float)1.0f);
            GlStateManager.func_179109_b((float)0.0625f, (float)0.0625f, (float)0.0625f);
            GlStateManager.func_179128_n((int)5888);
        } else if (this.getTexture() != null) {
            this.func_147499_a(this.getTexture());
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179091_B();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179109_b((float)((float)x), (float)((float)y + 1.0f), (float)((float)z + 1.0f));
        GlStateManager.func_179152_a((float)1.0f, (float)-1.0f, (float)-1.0f);
        this.preRotate(tile);
        int rotation = 0;
        if (direction == EnumFacing.SOUTH) {
            rotation = 180;
        }
        if (direction == EnumFacing.NORTH) {
            rotation = 0;
        }
        if (direction == EnumFacing.EAST) {
            rotation = 90;
        }
        if (direction == EnumFacing.WEST) {
            rotation = -90;
        }
        GlStateManager.func_179114_b((float)rotation, (float)0.0f, (float)1.0f, (float)0.0f);
        this.postRotate(tile);
        this.renderModel(tile, this.getModel(), partialTick, destroyStage);
        GlStateManager.func_179101_C();
        GlStateManager.func_179121_F();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (destroyStage >= 0) {
            GlStateManager.func_179128_n((int)5890);
            GlStateManager.func_179121_F();
            GlStateManager.func_179128_n((int)5888);
        }
    }

    protected abstract void renderModel(T var1, M var2, float var3, int var4);

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RenderTileEntityModel)) {
            return false;
        }
        RenderTileEntityModel other = (RenderTileEntityModel)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        M this$model = this.getModel();
        M other$model = other.getModel();
        if (this$model == null ? other$model != null : !this$model.equals(other$model)) {
            return false;
        }
        ResourceLocation this$texture = this.getTexture();
        ResourceLocation other$texture = other.getTexture();
        return !(this$texture == null ? other$texture != null : !this$texture.equals(other$texture));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RenderTileEntityModel;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        M $model = this.getModel();
        result = result * 59 + ($model == null ? 0 : $model.hashCode());
        ResourceLocation $texture = this.getTexture();
        result = result * 59 + ($texture == null ? 0 : $texture.hashCode());
        return result;
    }

    public M getModel() {
        return this.model;
    }

    public String toString() {
        return "RenderTileEntityModel(model=" + this.getModel() + ", texture=" + this.getTexture() + ")";
    }
}

