/*
 * Decompiled with CFR 0.152.
 */
package tv.darkosto.sevtweaks.network;

import com.google.common.collect.ArrayListMultimap;
import hunternif.mc.atlas.marker.Marker;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.client.Minecraft;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import tv.darkosto.sevtweaks.common.compat.modules.AaToJmWaypoints;

public class MarkersSyncPacket
implements IMessage {
    Collection<Marker> markers;

    public MarkersSyncPacket() {
        this.markers = new ArrayList<Marker>();
    }

    public MarkersSyncPacket(Collection<Marker> markers) {
        this.markers = markers;
    }

    public void fromBytes(ByteBuf buf) {
        PacketBuffer packetBuffer = new PacketBuffer(buf);
        int typeCount = packetBuffer.func_150792_a();
        for (int i = 0; i < typeCount; ++i) {
            String typeName = ByteBufUtils.readUTF8String((ByteBuf)packetBuffer);
            int markerCount = packetBuffer.func_150792_a();
            for (int j = 0; j < markerCount; ++j) {
                this.markers.add(new Marker(j, typeName, ByteBufUtils.readUTF8String((ByteBuf)packetBuffer), packetBuffer.func_150792_a(), packetBuffer.func_150792_a(), packetBuffer.func_150792_a(), true));
            }
        }
    }

    public void toBytes(ByteBuf buf) {
        PacketBuffer packetBuffer = new PacketBuffer(buf);
        ArrayListMultimap markerTypeMap = ArrayListMultimap.create();
        for (Marker marker : this.markers) {
            markerTypeMap.put((Object)marker.getType(), (Object)marker);
        }
        packetBuffer.func_150787_b(markerTypeMap.keySet().size());
        for (String type : markerTypeMap.keySet()) {
            ByteBufUtils.writeUTF8String((ByteBuf)packetBuffer, (String)type);
            packetBuffer.func_150787_b(markerTypeMap.get((Object)type).size());
            for (Marker marker : markerTypeMap.get((Object)type)) {
                ByteBufUtils.writeUTF8String((ByteBuf)packetBuffer, (String)marker.getLabel());
                packetBuffer.func_150787_b(marker.getDimension());
                packetBuffer.func_150787_b(marker.getX());
                packetBuffer.func_150787_b(marker.getZ());
            }
        }
    }

    public static class MessageHandler
    implements IMessageHandler<MarkersSyncPacket, IMessage> {
        public IMessage onMessage(MarkersSyncPacket message, MessageContext ctx) {
            Minecraft.func_71410_x().func_152344_a(() -> AaToJmWaypoints.doSync(message.markers));
            return null;
        }
    }
}

