/*
 * Decompiled with CFR 0.152.
 */
package tv.darkosto.sevtweaks.common.crash;

import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.fml.common.ICrashCallable;
import net.minecraftforge.fml.common.Loader;
import tv.darkosto.sevtweaks.common.config.Configuration;

public class PackCrashEnhancement
implements ICrashCallable {
    public String getLabel() {
        String label = Configuration.crashData.name;
        if (label == null || label.length() == 0) {
            return "Modpack Data";
        }
        return label;
    }

    public String call() {
        StringBuilder builder = new StringBuilder();
        for (String data : this.getData()) {
            builder.append(String.format("\n\t\t%s", data));
        }
        return builder.toString();
    }

    private List<String> getData() {
        ArrayList<String> data = new ArrayList<String>();
        data.add(String.format("Version: %s", Configuration.crashData.version));
        try {
            Class<?> optifineConfClass = Class.forName("Config", false, (ClassLoader)Loader.instance().getModClassLoader());
            String optifineVersion = (String)optifineConfClass.getField("VERSION").get(null);
            data.add(String.format("Optifine Installed: True (%s)", optifineVersion));
        }
        catch (Exception err) {
            data.add("Optifine Installed: False");
        }
        return data;
    }
}

