/*
 * Decompiled with CFR 0.152.
 */
package tv.darkosto.sevtweaks.common.compat;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraftforge.fml.common.Loader;
import tv.darkosto.sevtweaks.SevTweaks;
import tv.darkosto.sevtweaks.common.compat.ICompat;
import tv.darkosto.sevtweaks.common.compat.modules.AaToJmWaypoints;
import tv.darkosto.sevtweaks.common.compat.modules.BetterWithMods;
import tv.darkosto.sevtweaks.common.compat.modules.GalacticraftPlanets;
import tv.darkosto.sevtweaks.common.compat.modules.Natura;
import tv.darkosto.sevtweaks.common.compat.modules.Rustic;
import tv.darkosto.sevtweaks.common.compat.modules.Totemic;

public class Compat {
    private static HashMap<String, Class<? extends ICompat>> compatModules = new HashMap();
    private static Set<ICompat> modules = new HashSet<ICompat>();

    public static void compactPreInit() {
        for (Map.Entry<String, Class<? extends ICompat>> e : compatModules.entrySet()) {
            if (!Loader.isModLoaded((String)e.getKey())) continue;
            try {
                ICompat compat = e.getValue().newInstance();
                modules.add(compat);
                compat.preInit();
            }
            catch (Exception el) {
                SevTweaks.logger.error("Compat module for " + e.getKey() + " could not be preInitialized.");
            }
        }
    }

    public static void compactInit() {
        for (ICompat compat : modules) {
            try {
                compat.init();
            }
            catch (Exception el) {
                SevTweaks.logger.error("Compat module for " + compat + " could not be initialized.", (Throwable)el);
            }
        }
    }

    public static void compactPostInit() {
        for (ICompat compat : modules) {
            try {
                compat.postInit();
            }
            catch (Exception el) {
                SevTweaks.logger.error("Compat module for " + compat + " could not be postInitialized.", (Throwable)el);
            }
        }
    }

    static {
        compatModules.put("natura", Natura.class);
        compatModules.put("rustic", Rustic.class);
        compatModules.put("betterwithmods", BetterWithMods.class);
        compatModules.put("galacticraftplanets", GalacticraftPlanets.class);
        compatModules.put("antiqueatlas", AaToJmWaypoints.class);
        compatModules.put("totemic", Totemic.class);
    }
}

