/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.jeid.mixin.core;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.stats.StatBase;
import net.minecraft.stats.StatCrafting;
import net.minecraft.stats.StatList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={StatList.class}, priority=500)
public final class MixinStatList {
    @Shadow
    @Final
    protected static Map<String, StatBase> field_188093_a;
    @Shadow
    @Final
    public static List<StatBase> field_188094_c;
    @Shadow
    @Final
    public static List<StatCrafting> field_188095_d;
    @Shadow
    @Final
    public static List<StatCrafting> field_188096_e;
    @Shadow
    @Final
    public static List<StatBase> field_75940_b;
    private static final Map<Block, StatBase> BLOCK_STAT_MAP;
    private static final Map<Item, StatBase> CRAFTS_STATS_MAP;
    private static final Map<Item, StatBase> OBJECT_USE_STATS_MAP;
    private static final Map<Item, StatBase> OBJECT_BREAK_STATS_MAP;
    private static final Map<Item, StatBase> OBJECTS_PICKED_UP_STATS_MAP;
    private static final Map<Item, StatBase> OBJECTS_DROPPED_STATS_MAP;

    @Overwrite
    @Nullable
    public static StatBase func_188055_a(Block block) {
        return BLOCK_STAT_MAP.get(block);
    }

    @Overwrite
    @Nullable
    public static StatBase func_188060_a(Item item) {
        return CRAFTS_STATS_MAP.get(item);
    }

    @Overwrite
    @Nullable
    public static StatBase func_188057_b(Item item) {
        return OBJECT_USE_STATS_MAP.get(item);
    }

    @Overwrite
    @Nullable
    public static StatBase func_188059_c(Item item) {
        return OBJECT_BREAK_STATS_MAP.get(item);
    }

    @Overwrite
    @Nullable
    public static StatBase func_188056_d(Item item) {
        return OBJECTS_PICKED_UP_STATS_MAP.get(item);
    }

    @Overwrite
    @Nullable
    public static StatBase func_188058_e(Item item) {
        return OBJECTS_DROPPED_STATS_MAP.get(item);
    }

    @Overwrite
    public static void func_151178_a() {
        MixinStatList.func_151181_c();
        MixinStatList.func_75925_c();
        MixinStatList.func_151179_e();
        MixinStatList.func_75918_d();
        MixinStatList.initPickedUpAndDroppedStats();
    }

    @Overwrite
    private static void func_151181_c() {
        for (Block block : Block.field_149771_c) {
            Item item = Item.func_150898_a((Block)block);
            if (!block.func_149652_G() || item == Items.field_190931_a || MixinStatList.getItemName(item) == null) continue;
            StatCrafting stat = new StatCrafting("stat.mineBlock.", MixinStatList.getItemName(item), (ITextComponent)new TextComponentTranslation("stat.mineBlock", new Object[]{new ItemStack(block).func_151000_E()}), item);
            field_188096_e.add(stat);
            BLOCK_STAT_MAP.put(block, (StatBase)stat);
            stat.func_75971_g();
        }
    }

    @Overwrite
    private static void func_75925_c() {
        for (Item item : Item.field_150901_e) {
            if (item == null || MixinStatList.getItemName(item) == null) continue;
            StatCrafting stat = new StatCrafting("stat.useItem.", MixinStatList.getItemName(item), (ITextComponent)new TextComponentTranslation("stat.useItem", new Object[]{new ItemStack(item).func_151000_E()}), item);
            OBJECT_USE_STATS_MAP.put(item, (StatBase)stat);
            if (!(item instanceof ItemBlock)) {
                field_188095_d.add(stat);
            }
            stat.func_75971_g();
        }
    }

    @Overwrite
    private static void func_75918_d() {
        HashSet craftableItems = Sets.newHashSet();
        for (IRecipe recipe : CraftingManager.field_193380_a) {
            ItemStack output = recipe.func_77571_b();
            if (output.func_190926_b()) continue;
            craftableItems.add(recipe.func_77571_b().func_77973_b());
        }
        for (ItemStack furnaceRecipeOutputs : FurnaceRecipes.func_77602_a().func_77599_b().values()) {
            craftableItems.add(furnaceRecipeOutputs.func_77973_b());
        }
        for (Item item : craftableItems) {
            if (item == null || MixinStatList.getItemName(item) == null) continue;
            StatCrafting stat = new StatCrafting("stat.craftItem.", MixinStatList.getItemName(item), (ITextComponent)new TextComponentTranslation("stat.craftItem", new Object[]{new ItemStack(item).func_151000_E()}), item);
            CRAFTS_STATS_MAP.put(item, (StatBase)stat);
            stat.func_75971_g();
        }
    }

    @Overwrite
    private static void func_151179_e() {
        for (Item item : Item.field_150901_e) {
            if (item == null || MixinStatList.getItemName(item) == null || !item.func_77645_m()) continue;
            StatCrafting stat = new StatCrafting("stat.breakItem.", MixinStatList.getItemName(item), (ITextComponent)new TextComponentTranslation("stat.breakItem", new Object[]{new ItemStack(item).func_151000_E()}), item);
            OBJECT_BREAK_STATS_MAP.put(item, (StatBase)stat);
            stat.func_75971_g();
        }
    }

    private static void initPickedUpAndDroppedStats() {
        for (Item item : Item.field_150901_e) {
            if (item == null || MixinStatList.getItemName(item) == null) continue;
            StatCrafting pickupStat = new StatCrafting("stat.pickup.", MixinStatList.getItemName(item), (ITextComponent)new TextComponentTranslation("stat.pickup", new Object[]{new ItemStack(item).func_151000_E()}), item);
            StatCrafting dropStat = new StatCrafting("stat.drop.", MixinStatList.getItemName(item), (ITextComponent)new TextComponentTranslation("stat.drop", new Object[]{new ItemStack(item).func_151000_E()}), item);
            OBJECTS_PICKED_UP_STATS_MAP.put(item, (StatBase)pickupStat);
            OBJECTS_DROPPED_STATS_MAP.put(item, (StatBase)dropStat);
            pickupStat.func_75971_g();
            dropStat.func_75971_g();
        }
    }

    private static String getItemName(Item itemIn) {
        ResourceLocation resourcelocation = (ResourceLocation)Item.field_150901_e.func_177774_c((Object)itemIn);
        return resourcelocation != null ? resourcelocation.toString().replace(':', '.') : null;
    }

    @Overwrite
    @Deprecated
    public static void reinit() {
        field_188093_a.clear();
        field_188094_c.clear();
        field_188095_d.clear();
        field_188096_e.clear();
        HashSet<StatBase> knownStats = new HashSet<StatBase>();
        knownStats.addAll(BLOCK_STAT_MAP.values());
        knownStats.addAll(CRAFTS_STATS_MAP.values());
        knownStats.addAll(OBJECT_USE_STATS_MAP.values());
        knownStats.addAll(OBJECT_BREAK_STATS_MAP.values());
        knownStats.addAll(OBJECTS_PICKED_UP_STATS_MAP.values());
        knownStats.addAll(OBJECTS_DROPPED_STATS_MAP.values());
        ArrayList<StatBase> unknownStats = new ArrayList<StatBase>();
        for (StatBase stat : field_75940_b) {
            if (knownStats.contains(stat)) continue;
            unknownStats.add(stat);
        }
        BLOCK_STAT_MAP.clear();
        CRAFTS_STATS_MAP.clear();
        OBJECT_USE_STATS_MAP.clear();
        OBJECT_BREAK_STATS_MAP.clear();
        OBJECTS_PICKED_UP_STATS_MAP.clear();
        OBJECTS_DROPPED_STATS_MAP.clear();
        field_75940_b.clear();
        for (StatBase unknownStat : unknownStats) {
            unknownStat.func_75971_g();
        }
        MixinStatList.func_151178_a();
    }

    static {
        BLOCK_STAT_MAP = new HashMap<Block, StatBase>();
        CRAFTS_STATS_MAP = new HashMap<Item, StatBase>();
        OBJECT_USE_STATS_MAP = new HashMap<Item, StatBase>();
        OBJECT_BREAK_STATS_MAP = new HashMap<Item, StatBase>();
        OBJECTS_PICKED_UP_STATS_MAP = new HashMap<Item, StatBase>();
        OBJECTS_DROPPED_STATS_MAP = new HashMap<Item, StatBase>();
    }
}

