/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.jeid.mixin.core;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.BitArray;
import net.minecraft.world.chunk.BlockStateContainer;
import net.minecraft.world.chunk.IBlockStatePalette;
import net.minecraft.world.chunk.NibbleArray;
import org.dimdev.jeid.INewBlockStateContainer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={BlockStateContainer.class})
public abstract class MixinBlockStateContainer
implements INewBlockStateContainer {
    @Shadow
    protected BitArray field_186021_b;
    @Shadow
    protected IBlockStatePalette field_186022_c;
    private int[] temporaryPalette;

    @Shadow
    protected abstract IBlockState func_186015_a(int var1);

    @Shadow
    protected abstract void func_186014_b(int var1, IBlockState var2);

    @Shadow
    protected abstract void func_186012_b(int var1);

    @Override
    public int[] getTemporaryPalette() {
        return this.temporaryPalette;
    }

    @Override
    public void setTemporaryPalette(int[] temporaryPalette) {
        this.temporaryPalette = temporaryPalette;
    }

    @Inject(method={"getDataForNBT"}, at={@At(value="HEAD")}, cancellable=true)
    private void newGetDataForNBT(byte[] blockIds, NibbleArray data, CallbackInfoReturnable<NibbleArray> cir) {
        HashMap<IBlockState, Integer> stateIDMap = new HashMap<IBlockState, Integer>();
        int nextID = 0;
        for (int index = 0; index < 4096; ++index) {
            IBlockState state = this.func_186015_a(index);
            Integer paletteID = (Integer)stateIDMap.get(state);
            if (paletteID == null) {
                paletteID = nextID++;
                stateIDMap.put(state, paletteID);
            }
            int x = index & 0xF;
            int y = index >> 8 & 0xF;
            int z = index >> 4 & 0xF;
            blockIds[index] = (byte)(paletteID >> 4 & 0xFF);
            data.func_76581_a(x, y, z, paletteID & 0xF);
        }
        this.temporaryPalette = new int[nextID];
        for (Map.Entry entry : stateIDMap.entrySet()) {
            this.temporaryPalette[((Integer)entry.getValue()).intValue()] = Block.field_176229_d.func_148747_b(entry.getKey());
        }
        cir.setReturnValue(null);
        cir.cancel();
    }

    @Inject(method={"setDataFromNBT"}, at={@At(value="HEAD")}, cancellable=true)
    private void newSetDataFromNBT(byte[] blockIds, NibbleArray data, NibbleArray blockIdExtension, CallbackInfo ci) {
        if (this.temporaryPalette == null) {
            return;
        }
        for (int index = 0; index < 4096; ++index) {
            int x = index & 0xF;
            int y = index >> 8 & 0xF;
            int z = index >> 4 & 0xF;
            int paletteID = (blockIds[index] & 0xFF) << 4 | data.func_76582_a(x, y, z);
            this.func_186014_b(index, (IBlockState)Block.field_176229_d.func_148745_a(this.temporaryPalette[paletteID]));
        }
        this.temporaryPalette = null;
        ci.cancel();
    }
}

