/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.network;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.energy.wires.ImmersiveNetHandler;
import blusunrize.immersiveengineering.common.entities.EntitySkylineHook;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class MessageSkyhookSync
implements IMessage {
    private int entityID;
    private ImmersiveNetHandler.Connection connection;
    private double linePos;
    private double speed;

    public MessageSkyhookSync(EntitySkylineHook entity) {
        this.entityID = entity.func_145782_y();
        this.connection = entity.getConnection();
        this.linePos = entity.linePos;
        this.speed = entity.horizontalSpeed;
    }

    public MessageSkyhookSync() {
    }

    public void fromBytes(ByteBuf buf) {
        this.entityID = buf.readInt();
        NBTTagCompound tag = ByteBufUtils.readTag((ByteBuf)buf);
        this.connection = ImmersiveNetHandler.Connection.readFromNBT(tag);
        this.linePos = buf.readDouble();
        this.speed = buf.readDouble();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.entityID);
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.connection.writeToNBT());
        buf.writeDouble(this.linePos);
        buf.writeDouble(this.speed);
    }

    public static class Handler
    implements IMessageHandler<MessageSkyhookSync, IMessage> {
        public IMessage onMessage(MessageSkyhookSync message, MessageContext ctx) {
            Minecraft.func_71410_x().func_152344_a(() -> {
                Entity ent;
                World world = ImmersiveEngineering.proxy.getClientWorld();
                if (world != null && (ent = world.func_73045_a(message.entityID)) instanceof EntitySkylineHook) {
                    message.connection.getSubVertices(world);
                    ((EntitySkylineHook)ent).setConnectionAndPos(message.connection, message.linePos, message.speed);
                }
            });
            return null;
        }
    }
}

