/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.network;

import blusunrize.immersiveengineering.common.gui.IESlot;
import blusunrize.immersiveengineering.common.util.IELogger;
import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class MessageSetGhostSlots
implements IMessage {
    private Int2ObjectMap<ItemStack> stacksToSet;

    public MessageSetGhostSlots(Int2ObjectMap<ItemStack> stacksToSet) {
        this.stacksToSet = stacksToSet;
    }

    public MessageSetGhostSlots() {
    }

    public void fromBytes(ByteBuf buf) {
        int size = buf.readInt();
        this.stacksToSet = new Int2ObjectOpenHashMap(size);
        for (int i = 0; i < size; ++i) {
            int slot = buf.readInt();
            NBTTagCompound nbt = ByteBufUtils.readTag((ByteBuf)buf);
            assert (nbt != null);
            ItemStack stack = new ItemStack(nbt);
            this.stacksToSet.put(slot, (Object)stack);
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.stacksToSet.size());
        for (Int2ObjectMap.Entry e : this.stacksToSet.int2ObjectEntrySet()) {
            buf.writeInt(e.getIntKey());
            NBTTagCompound nbt = new NBTTagCompound();
            ((ItemStack)e.getValue()).func_77955_b(nbt);
            ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)nbt);
        }
    }

    public static class Handler
    implements IMessageHandler<MessageSetGhostSlots, IMessage> {
        public IMessage onMessage(MessageSetGhostSlots msg, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            WorldServer world = player.func_71121_q();
            world.func_152344_a(() -> {
                Container container = player.field_71070_bA;
                if (container != null) {
                    for (Int2ObjectMap.Entry e : msg.stacksToSet.int2ObjectEntrySet()) {
                        int slot = e.getIntKey();
                        if (slot < 0 || slot >= container.field_75151_b.size()) continue;
                        Slot target = (Slot)container.field_75151_b.get(slot);
                        if (!(target instanceof IESlot.Ghost)) {
                            IELogger.error("Player " + player.func_145748_c_() + " tried to set the contents of a non-ghost slot.This is either a bug in IE or an attempt at cheating.");
                            return;
                        }
                        container.func_75141_a(slot, (ItemStack)e.getValue());
                    }
                }
            });
            return null;
        }
    }
}

