/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.compat.crafttweaker;

import blusunrize.immersiveengineering.api.energy.DieselHandler;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.api.liquid.ILiquidStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.immersiveengineering.DieselHandler")
public class DieselHelper {
    @ZenMethod
    public static void addFuel(ILiquidStack fuel, int time) {
        CraftTweakerAPI.apply((IAction)new AddFuel(fuel, time));
    }

    @ZenMethod
    public static void addDrillFuel(ILiquidStack fuel) {
        CraftTweakerAPI.apply((IAction)new AddDrillFuel(fuel));
    }

    @ZenMethod
    public static void removeFuel(ILiquidStack fuel) {
        CraftTweakerAPI.apply((IAction)new RemoveFuel(fuel));
    }

    @ZenMethod
    public static void removeDrillFuel(ILiquidStack fuel) {
        CraftTweakerAPI.apply((IAction)new RemoveDrillFuel(fuel));
    }

    private static class RemoveDrillFuel
    implements IAction {
        private final ILiquidStack fuel;

        public RemoveDrillFuel(ILiquidStack fuel) {
            this.fuel = fuel;
        }

        public void apply() {
            Fluid fuelFluid = FluidRegistry.getFluid((String)this.fuel.getName());
            DieselHandler.removeDrillFuel(fuelFluid);
        }

        public String describe() {
            return "Removing Drill Fuel " + this.fuel.getDisplayName();
        }
    }

    private static class RemoveFuel
    implements IAction {
        private final ILiquidStack fuel;

        public RemoveFuel(ILiquidStack fuel) {
            this.fuel = fuel;
        }

        public void apply() {
            Fluid fuelFluid = FluidRegistry.getFluid((String)this.fuel.getName());
            DieselHandler.removeFuel(fuelFluid);
        }

        public String describe() {
            return "Removing Fuel " + this.fuel.getDisplayName();
        }
    }

    private static class AddDrillFuel
    implements IAction {
        private final ILiquidStack fuel;

        public AddDrillFuel(ILiquidStack fuel) {
            this.fuel = fuel;
        }

        public void apply() {
            Fluid fuelFluid = FluidRegistry.getFluid((String)this.fuel.getName());
            DieselHandler.registerDrillFuel(fuelFluid);
        }

        public String describe() {
            return "Registering Drill Fuel " + this.fuel.getDisplayName();
        }
    }

    private static class AddFuel
    implements IAction {
        private final ILiquidStack fuel;
        private final int time;

        public AddFuel(ILiquidStack fuel, int time) {
            this.fuel = fuel;
            this.time = time;
        }

        public void apply() {
            Fluid fuelFluid = FluidRegistry.getFluid((String)this.fuel.getName());
            DieselHandler.registerFuel(fuelFluid, this.time);
        }

        public String describe() {
            return "Registering Diesel Generator Fuel " + this.fuel.getDisplayName();
        }
    }
}

