/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.models;

import blusunrize.immersiveengineering.api.tool.ExcavatorHandler;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.chickenbones.Matrix4;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import javax.vecmath.Matrix4f;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.obj.OBJModel;
import net.minecraftforge.client.model.pipeline.LightUtil;
import net.minecraftforge.client.model.pipeline.UnpackedBakedQuad;
import net.minecraftforge.common.model.TRSRTransformation;
import org.apache.commons.lang3.tuple.Pair;
import org.lwjgl.util.vector.Vector2f;
import org.lwjgl.util.vector.Vector3f;

public class ModelCoresample
implements IBakedModel {
    Set<BakedQuad> bakedQuads;
    static List<BakedQuad> emptyQuads = Lists.newArrayList();
    ExcavatorHandler.MineralMix mineral;
    public static final HashMap<String, ModelCoresample> modelCache = new HashMap();
    ItemOverrideList overrideList = new ItemOverrideList(new ArrayList()){

        public IBakedModel handleItemState(IBakedModel originalModel, ItemStack stack, World world, EntityLivingBase entity) {
            String name;
            if (ItemNBTHelper.hasKey(stack, "mineral") && (name = ItemNBTHelper.getString(stack, "mineral")) != null && !name.isEmpty()) {
                IBakedModel model;
                if (!modelCache.containsKey(name)) {
                    for (ExcavatorHandler.MineralMix mix : ExcavatorHandler.mineralList.keySet()) {
                        if (!name.equals(mix.name)) continue;
                        modelCache.put(name, new ModelCoresample(mix));
                    }
                }
                if ((model = (IBakedModel)modelCache.get(name)) != null) {
                    return model;
                }
            }
            return originalModel;
        }
    };
    static HashMap<ItemCameraTransforms.TransformType, Matrix4> transformationMap = new HashMap();

    public ModelCoresample(ExcavatorHandler.MineralMix mineral) {
        this.mineral = mineral;
    }

    public ModelCoresample() {
        this(null);
    }

    public List<BakedQuad> func_188616_a(@Nullable IBlockState blockState, @Nullable EnumFacing side, long rand) {
        if (this.bakedQuads == null) {
            try {
                this.bakedQuads = Collections.synchronizedSet(new LinkedHashSet());
                float width = 0.25f;
                float depth = 0.25f;
                float wOff = (1.0f - width) / 2.0f;
                float dOff = (1.0f - depth) / 2.0f;
                int pixelLength = 0;
                HashMap<TextureAtlasSprite, Integer> textureOre = new HashMap<TextureAtlasSprite, Integer>();
                if (this.mineral != null && this.mineral.oreOutput != null) {
                    for (int i = 0; i < this.mineral.oreOutput.size(); ++i) {
                        if (((ItemStack)this.mineral.oreOutput.get(i)).func_190926_b()) continue;
                        int weight = Math.max(2, Math.round(16.0f * this.mineral.recalculatedChances[i]));
                        Block b = Block.func_149634_a((Item)((ItemStack)this.mineral.oreOutput.get(i)).func_77973_b());
                        IBlockState state = b != null && b != Blocks.field_150350_a ? b.func_176203_a(((ItemStack)this.mineral.oreOutput.get(i)).func_77960_j()) : Blocks.field_150348_b.func_176223_P();
                        IBakedModel model = Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178125_b(state);
                        if (model != null && model.func_177554_e() != null) {
                            textureOre.put(model.func_177554_e(), weight);
                        }
                        pixelLength += weight;
                    }
                } else {
                    pixelLength = 16;
                }
                TextureAtlasSprite textureStone = ClientUtils.getSprite(new ResourceLocation("blocks/stone"));
                Vector2f[] stoneUVs = new Vector2f[]{new Vector2f(16.0f * wOff, 16.0f * dOff), new Vector2f(16.0f * wOff, 16.0f * (dOff + depth)), new Vector2f(16.0f * (wOff + width), 16.0f * (dOff + depth)), new Vector2f(16.0f * (wOff + width), 16.0f * dOff)};
                this.putVertexData(new Vector3f(0.0f, -1.0f, 0.0f), new Vector3f[]{new Vector3f(wOff, 0.0f, dOff), new Vector3f(wOff + width, 0.0f, dOff), new Vector3f(wOff + width, 0.0f, dOff + depth), new Vector3f(wOff, 0.0f, dOff + depth)}, stoneUVs, textureStone);
                this.putVertexData(new Vector3f(0.0f, 1.0f, 0.0f), new Vector3f[]{new Vector3f(wOff, 1.0f, dOff), new Vector3f(wOff, 1.0f, dOff + depth), new Vector3f(wOff + width, 1.0f, dOff + depth), new Vector3f(wOff + width, 1.0f, dOff)}, stoneUVs, textureStone);
                if (textureOre.isEmpty()) {
                    Vector2f[][] uvs = new Vector2f[4][];
                    for (int j = 0; j < 4; ++j) {
                        uvs[j] = new Vector2f[]{new Vector2f((float)(j * 4), 0.0f), new Vector2f((float)(j * 4), 16.0f), new Vector2f((float)((j + 1) * 4), 16.0f), new Vector2f((float)((j + 1) * 4), 0.0f)};
                    }
                    this.putVertexData(new Vector3f(0.0f, 0.0f, -1.0f), new Vector3f[]{new Vector3f(wOff, 0.0f, dOff), new Vector3f(wOff, 1.0f, dOff), new Vector3f(wOff + width, 1.0f, dOff), new Vector3f(wOff + width, 0.0f, dOff)}, uvs[0], textureStone);
                    this.putVertexData(new Vector3f(0.0f, 0.0f, 1.0f), new Vector3f[]{new Vector3f(wOff + width, 0.0f, dOff + depth), new Vector3f(wOff + width, 1.0f, dOff + depth), new Vector3f(wOff, 1.0f, dOff + depth), new Vector3f(wOff, 0.0f, dOff + depth)}, uvs[2], textureStone);
                    this.putVertexData(new Vector3f(-1.0f, 0.0f, 0.0f), new Vector3f[]{new Vector3f(wOff, 0.0f, dOff + depth), new Vector3f(wOff, 1.0f, dOff + depth), new Vector3f(wOff, 1.0f, dOff), new Vector3f(wOff, 0.0f, dOff)}, uvs[3], textureStone);
                    this.putVertexData(new Vector3f(1.0f, 0.0f, 0.0f), new Vector3f[]{new Vector3f(wOff + width, 0.0f, dOff), new Vector3f(wOff + width, 1.0f, dOff), new Vector3f(wOff + width, 1.0f, dOff + depth), new Vector3f(wOff + width, 0.0f, dOff + depth)}, uvs[1], textureStone);
                } else {
                    float h = 0.0f;
                    for (TextureAtlasSprite sprite : textureOre.keySet()) {
                        int weight = (Integer)textureOre.get(sprite);
                        int v = weight > 8 ? 16 - weight : 8;
                        Vector2f[][] uvs = new Vector2f[4][];
                        for (int j = 0; j < 4; ++j) {
                            uvs[j] = new Vector2f[]{new Vector2f((float)(j * 4), (float)v), new Vector2f((float)(j * 4), (float)(v + weight)), new Vector2f((float)((j + 1) * 4), (float)(v + weight)), new Vector2f((float)((j + 1) * 4), (float)v)};
                        }
                        float h1 = (float)weight / (float)pixelLength;
                        this.putVertexData(new Vector3f(0.0f, 0.0f, -1.0f), new Vector3f[]{new Vector3f(wOff, h, dOff), new Vector3f(wOff, h + h1, dOff), new Vector3f(wOff + width, h + h1, dOff), new Vector3f(wOff + width, h, dOff)}, uvs[0], sprite);
                        this.putVertexData(new Vector3f(0.0f, 0.0f, 1.0f), new Vector3f[]{new Vector3f(wOff + width, h, dOff + depth), new Vector3f(wOff + width, h + h1, dOff + depth), new Vector3f(wOff, h + h1, dOff + depth), new Vector3f(wOff, h, dOff + depth)}, uvs[2], sprite);
                        this.putVertexData(new Vector3f(-1.0f, 0.0f, 0.0f), new Vector3f[]{new Vector3f(wOff, h, dOff + depth), new Vector3f(wOff, h + h1, dOff + depth), new Vector3f(wOff, h + h1, dOff), new Vector3f(wOff, h, dOff)}, uvs[3], sprite);
                        this.putVertexData(new Vector3f(1.0f, 0.0f, 0.0f), new Vector3f[]{new Vector3f(wOff + width, h, dOff), new Vector3f(wOff + width, h + h1, dOff), new Vector3f(wOff + width, h + h1, dOff + depth), new Vector3f(wOff + width, h, dOff + depth)}, uvs[1], sprite);
                        h += h1;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.bakedQuads != null && !this.bakedQuads.isEmpty()) {
            List<BakedQuad> quadList = Collections.synchronizedList(Lists.newArrayList(this.bakedQuads));
            return quadList;
        }
        return emptyQuads;
    }

    protected final void putVertexData(Vector3f normal, Vector3f[] vertices, Vector2f[] uvs, TextureAtlasSprite sprite) {
        UnpackedBakedQuad.Builder builder = new UnpackedBakedQuad.Builder(DefaultVertexFormats.field_176599_b);
        builder.setQuadOrientation(EnumFacing.func_176737_a((float)normal.x, (float)normal.y, (float)normal.z));
        builder.setTexture(sprite);
        OBJModel.Normal objNormal = new OBJModel.Normal(normal.x, normal.y, normal.z);
        for (int i = 0; i < vertices.length; ++i) {
            float d = LightUtil.diffuseLight((float)normal.x, (float)normal.y, (float)normal.z);
            ClientUtils.putVertexData(builder.getVertexFormat(), builder, vertices[i], objNormal, uvs[i].x, uvs[i].y, sprite, new float[]{d, d, d, 1.0f}, 1.0f);
        }
        this.bakedQuads.add((BakedQuad)builder.build());
    }

    public boolean func_177555_b() {
        return true;
    }

    public boolean func_177556_c() {
        return true;
    }

    public boolean func_188618_c() {
        return false;
    }

    public TextureAtlasSprite func_177554_e() {
        return null;
    }

    public ItemCameraTransforms func_177552_f() {
        return ItemCameraTransforms.field_178357_a;
    }

    public ItemOverrideList func_188617_f() {
        return this.overrideList;
    }

    public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
        return Pair.of((Object)this, (Object)TRSRTransformation.identity().getMatrix());
    }

    static {
        transformationMap.put(ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND, new Matrix4().translate(0.0, 0.28, 0.0).rotate(Math.toRadians(180.0), 1.0, 0.0, 0.0).rotate(Math.toRadians(-90.0), 0.0, 1.0, 0.0));
        transformationMap.put(ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND, new Matrix4().translate(0.0, 0.28, 0.0).rotate(Math.toRadians(180.0), 1.0, 0.0, 0.0).rotate(Math.toRadians(-90.0), 0.0, 1.0, 0.0));
        transformationMap.put(ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND, new Matrix4().translate(0.0, 0.0625, -0.125).scale(0.625, 0.625, 0.625).rotate(Math.toRadians(30.0), 1.0, 0.0, 0.0).rotate(Math.toRadians(130.0), 0.0, 1.0, 0.0));
        transformationMap.put(ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, new Matrix4().translate(0.0, 0.0625, -0.125).scale(0.625, 0.625, 0.625).rotate(Math.toRadians(30.0), 1.0, 0.0, 0.0).rotate(Math.toRadians(130.0), 0.0, 1.0, 0.0));
        transformationMap.put(ItemCameraTransforms.TransformType.GUI, new Matrix4().scale(1.25, 1.25, 1.25).rotate(Math.toRadians(180.0), 1.0, 0.0, 0.0).rotate(Math.toRadians(20.0), 0.0, 1.0, 0.0).rotate(Math.toRadians(-30.0), 0.0, 0.0, 1.0));
        transformationMap.put(ItemCameraTransforms.TransformType.FIXED, new Matrix4().scale(1.5, 1.5, 1.5).rotate(Math.toRadians(180.0), 1.0, 0.0, 0.0));
        transformationMap.put(ItemCameraTransforms.TransformType.GROUND, new Matrix4().scale(1.5, 1.5, 1.5).rotate(Math.toRadians(180.0), 1.0, 0.0, 0.0));
    }
}

