/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.crafting;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.crafting.IngredientStack;
import blusunrize.immersiveengineering.api.crafting.MultiblockRecipe;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fluids.FluidStack;

public class MixerRecipe
extends MultiblockRecipe {
    public static float energyModifier = 1.0f;
    public static float timeModifier = 1.0f;
    public final IngredientStack[] itemInputs;
    public final FluidStack fluidInput;
    public final FluidStack fluidOutput;
    public final int fluidAmount;
    public static ArrayList<MixerRecipe> recipeList = new ArrayList();

    public MixerRecipe(FluidStack fluidOutput, FluidStack fluidInput, Object[] itemInputs, int energy) {
        this.fluidOutput = fluidOutput;
        this.fluidAmount = fluidOutput.amount;
        this.fluidInput = fluidInput;
        this.itemInputs = new IngredientStack[itemInputs == null ? 0 : itemInputs.length];
        if (itemInputs != null) {
            for (int i = 0; i < itemInputs.length; ++i) {
                this.itemInputs[i] = ApiUtils.createIngredientStack(itemInputs[i]);
            }
        }
        this.totalProcessEnergy = (int)Math.floor((float)energy * energyModifier);
        this.totalProcessTime = (int)Math.floor((float)fluidOutput.amount * timeModifier);
        this.fluidInputList = Lists.newArrayList((Object[])new FluidStack[]{this.fluidInput});
        this.inputList = Lists.newArrayList((Object[])this.itemInputs);
        this.fluidOutputList = Lists.newArrayList((Object[])new FluidStack[]{this.fluidOutput});
    }

    public static MixerRecipe addRecipe(FluidStack fluidOutput, FluidStack fluidInput, Object[] itemInput, int energy) {
        MixerRecipe r = new MixerRecipe(fluidOutput, fluidInput, itemInput, energy);
        recipeList.add(r);
        return r;
    }

    public static MixerRecipe findRecipe(FluidStack fluid, NonNullList<ItemStack> components) {
        if (fluid == null) {
            return null;
        }
        for (MixerRecipe recipe : recipeList) {
            if (!recipe.matches(fluid, components)) continue;
            return recipe;
        }
        return null;
    }

    public FluidStack getFluidOutput(FluidStack input, NonNullList<ItemStack> components) {
        return this.fluidOutput;
    }

    public boolean matches(FluidStack fluid, NonNullList<ItemStack> components) {
        return this.compareToInputs(fluid, components, this.fluidInput, this.itemInputs);
    }

    protected boolean compareToInputs(FluidStack fluid, NonNullList<ItemStack> components, FluidStack fluidInput, IngredientStack[] itemInputs) {
        if (fluid != null && fluid.containsFluid(fluidInput)) {
            ArrayList<ItemStack> queryList = new ArrayList<ItemStack>(components.size());
            for (ItemStack s : components) {
                if (s.func_190926_b()) continue;
                queryList.add(s.func_77946_l());
            }
            for (IngredientStack add : itemInputs) {
                if (add == null) continue;
                int addAmount = add.inputSize;
                Iterator it = queryList.iterator();
                while (it.hasNext()) {
                    ItemStack query = (ItemStack)it.next();
                    if (query.func_190926_b()) continue;
                    if (add.matches(query)) {
                        if (query.func_190916_E() > addAmount) {
                            query.func_190918_g(addAmount);
                            addAmount = 0;
                        } else {
                            addAmount -= query.func_190916_E();
                            query.func_190920_e(0);
                        }
                    }
                    if (query.func_190916_E() <= 0) {
                        it.remove();
                    }
                    if (addAmount > 0) continue;
                    break;
                }
                if (addAmount <= 0) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int[] getUsedSlots(FluidStack input, NonNullList<ItemStack> components) {
        HashSet<Integer> usedSlotSet = new HashSet<Integer>();
        block0: for (int i = 0; i < this.itemInputs.length; ++i) {
            IngredientStack ingr = this.itemInputs[i];
            for (int j = 0; j < components.size(); ++j) {
                if (usedSlotSet.contains(j) || ((ItemStack)components.get(j)).func_190926_b() || !ingr.matchesItemStack((ItemStack)components.get(j))) continue;
                usedSlotSet.add(j);
                continue block0;
            }
        }
        int it = 0;
        int[] processSlots = new int[usedSlotSet.size()];
        for (Integer slot : usedSlotSet) {
            processSlots[it++] = slot;
        }
        return processSlots;
    }

    @Override
    public int getMultipleProcessTicks() {
        return 0;
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        nbt.func_74782_a("fluidInput", (NBTBase)this.fluidInput.writeToNBT(new NBTTagCompound()));
        if (this.itemInputs.length > 0) {
            NBTTagList list = new NBTTagList();
            for (IngredientStack add : this.itemInputs) {
                list.func_74742_a((NBTBase)add.writeToNBT(new NBTTagCompound()));
            }
            nbt.func_74782_a("itemInputs", (NBTBase)list);
        }
        return nbt;
    }

    public static MixerRecipe loadFromNBT(NBTTagCompound nbt) {
        FluidStack fluidInput = FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbt.func_74775_l("fluidInput"));
        IngredientStack[] itemInputs = null;
        if (nbt.func_74764_b("itemInputs")) {
            NBTTagList list = nbt.func_150295_c("itemInputs", 10);
            itemInputs = new IngredientStack[list.func_74745_c()];
            for (int i = 0; i < itemInputs.length; ++i) {
                itemInputs[i] = IngredientStack.readFromNBT(list.func_150305_b(i));
            }
        }
        for (MixerRecipe recipe : recipeList) {
            if (!recipe.fluidInput.equals((Object)fluidInput)) continue;
            if (itemInputs == null && recipe.itemInputs.length < 1) {
                return recipe;
            }
            if (itemInputs == null || recipe.itemInputs.length != itemInputs.length) continue;
            boolean b = true;
            for (int i = 0; i < itemInputs.length; ++i) {
                if (itemInputs[i].equals(recipe.itemInputs[i])) continue;
                b = false;
                break;
            }
            if (!b) continue;
            return recipe;
        }
        return null;
    }

    @Override
    public boolean shouldCheckItemAvailability() {
        return false;
    }
}

